"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PdfExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesPdfCommon = require("@kbn/reporting-export-types-pdf-common");
var _reportingServer = require("@kbn/reporting-server");
var _generate_pdf_v = require("./generate_pdf_v2");
var _get_custom_logo = require("./get_custom_logo");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PdfExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesPdfCommon.PDF_REPORT_TYPE_V2);
    (0, _defineProperty2.default)(this, "name", 'PDF');
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesPdfCommon.PDF_JOB_TYPE_V2);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'pdf');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    /**
     * @param JobParamsPDFV2
     * @returns jobParams
     */
    (0, _defineProperty2.default)(this, "createJob", async ({
      locatorParams,
      ...jobParams
    }) => {
      return {
        ...jobParams,
        locatorParams,
        isDeprecated: false,
        browserTimezone: jobParams.browserTimezone,
        forceNow: new Date().toISOString()
      };
    });
    /**
     *
     * @param jobId
     * @param payload
     * @param cancellationToken
     * @param stream
     */
    (0, _defineProperty2.default)(this, "runTask", (jobId, payload, cancellationToken, stream) => {
      const jobLogger = this.logger.get(`execute-job:${jobId}`);
      const apmTrans = _elasticApmNode.default.startTransaction('execute-job-pdf-v2', _reportingCommon.REPORTING_TRANSACTION_TYPE);
      const apmGetAssets = apmTrans.startSpan('get-assets', 'setup');
      let apmGeneratePdf;
      const {
        encryptionKey
      } = this.config;
      const process$ = (0, Rx.of)(1).pipe((0, Rx.mergeMap)(() => (0, _reportingServer.decryptJobHeaders)(encryptionKey, payload.headers, jobLogger)), (0, Rx.mergeMap)(async headers => {
        const fakeRequest = this.getFakeRequest(headers, payload.spaceId, jobLogger);
        const uiSettingsClient = await this.getUiSettingsClient(fakeRequest);
        return await (0, _get_custom_logo.getCustomLogo)(uiSettingsClient, headers);
      }), (0, Rx.mergeMap)(({
        logo,
        headers
      }) => {
        const {
          browserTimezone,
          layout,
          title,
          locatorParams
        } = payload;
        let urls;
        if (locatorParams) {
          urls = locatorParams.map(locator => [(0, _reportingServer.getFullRedirectAppUrl)(this.config, this.getServerInfo(), payload.spaceId, payload.forceNow), locator]);
        }
        apmGetAssets === null || apmGetAssets === void 0 ? void 0 : apmGetAssets.end();
        apmGeneratePdf = apmTrans.startSpan('generate-pdf-pipeline', 'execute');
        return (0, _generate_pdf_v.generatePdfObservableV2)(this.config, this.getServerInfo(), () => this.startDeps.screenshotting.getScreenshots({
          format: 'pdf',
          title,
          logo,
          browserTimezone,
          headers,
          layout,
          urls: urls.map(url => typeof url === 'string' ? url : [url[0], {
            [_reportingCommon.REPORTING_REDIRECT_LOCATOR_STORE_KEY]: url[1]
          }])
        }), payload, locatorParams, {
          format: 'pdf',
          title,
          logo,
          browserTimezone,
          headers,
          layout
        });
      }), (0, Rx.tap)(({
        buffer
      }) => {
        var _apmGeneratePdf;
        (_apmGeneratePdf = apmGeneratePdf) === null || _apmGeneratePdf === void 0 ? void 0 : _apmGeneratePdf.end();
        if (buffer) {
          stream.write(buffer);
        }
      }), (0, Rx.map)(({
        metrics,
        warnings
      }) => ({
        content_type: 'application/pdf',
        metrics: {
          pdf: metrics
        },
        warnings
      })), (0, Rx.catchError)(err => {
        jobLogger.error(err);
        return Rx.throwError(() => err);
      }));
      const stop$ = Rx.fromEventPattern(cancellationToken.on);
      apmTrans.end();
      return Rx.firstValueFrom(process$.pipe((0, Rx.takeUntil)(stop$)));
    });
    this.logger = this.logger.get('pdf-export-v2');
  }
}
exports.PdfExportType = PdfExportType;