"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvSearchSourceExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _generateCsv = require("@kbn/generate-csv");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _reportingServer = require("@kbn/reporting-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class CsvSearchSourceExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesCsvCommon.CSV_REPORT_TYPE);
    (0, _defineProperty2.default)(this, "name", _reportingExportTypesCsvCommon.CSV_JOB_TYPE);
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesCsvCommon.CSV_JOB_TYPE);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'csv');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_BASIC, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    (0, _defineProperty2.default)(this, "createJob", async jobParams => {
      return {
        ...jobParams
      };
    });
    (0, _defineProperty2.default)(this, "runTask", async (jobId, job, cancellationToken, stream) => {
      const {
        encryptionKey,
        csv: csvConfig
      } = this.config;
      const logger = this.logger.get(`execute-job:${jobId}`);
      const headers = await (0, _reportingServer.decryptJobHeaders)(encryptionKey, job.headers, logger);
      const fakeRequest = this.getFakeRequest(headers, job.spaceId, logger);
      const uiSettings = await this.getUiSettingsClient(fakeRequest, logger);
      const dataPluginStart = this.startDeps.data;
      const fieldFormatsRegistry = await (0, _reportingServer.getFieldFormats)().fieldFormatServiceFactory(uiSettings);
      const es = this.startDeps.esClient.asScoped(fakeRequest);
      const searchSourceStart = await dataPluginStart.search.searchSource.asScoped(fakeRequest);
      const clients = {
        uiSettings,
        data: dataPluginStart.search.asScoped(fakeRequest),
        es
      };
      const dependencies = {
        searchSourceStart,
        fieldFormatsRegistry
      };
      const csv = new _generateCsv.CsvGenerator(job, csvConfig, clients, dependencies, cancellationToken, logger, stream);
      return await csv.generateData();
    });
    this.logger = this.logger.get('csv-searchsource-export');
  }
}
exports.CsvSearchSourceExportType = CsvSearchSourceExportType;