"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRedirectAppPath = exports.UNVERSIONED_VERSION = exports.UI_SETTINGS_SEARCH_INCLUDE_FROZEN = exports.UI_SETTINGS_DATEFORMAT_TZ = exports.UI_SETTINGS_CUSTOM_PDF_LOGO = exports.REPORTING_TRANSACTION_TYPE = exports.REPORTING_SYSTEM_INDEX = exports.REPORTING_REDIRECT_LOCATOR_STORE_KEY = exports.REPORTING_MANAGEMENT_HOME = exports.PLUGIN_ID = exports.LICENSE_TYPE_TRIAL = exports.LICENSE_TYPE_PLATINUM = exports.LICENSE_TYPE_GOLD = exports.LICENSE_TYPE_ENTERPRISE = exports.LICENSE_TYPE_CLOUD_STANDARD = exports.LICENSE_TYPE_BASIC = exports.JOB_STATUS = exports.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = exports.ILM_POLICY_NAME = exports.API_USAGE_ERROR_TYPE = exports.API_USAGE_COUNTER_TYPE = exports.ALLOWED_JOB_CONTENT_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PLUGIN_ID = 'reporting';
exports.PLUGIN_ID = PLUGIN_ID;
const ALLOWED_JOB_CONTENT_TYPES = ['application/json', 'application/pdf', 'text/csv', 'image/png', 'text/plain'];

// APM
exports.ALLOWED_JOB_CONTENT_TYPES = ALLOWED_JOB_CONTENT_TYPES;
const REPORTING_TRANSACTION_TYPE = PLUGIN_ID;
exports.REPORTING_TRANSACTION_TYPE = REPORTING_TRANSACTION_TYPE;
const REPORTING_REDIRECT_LOCATOR_STORE_KEY = '__REPORTING_REDIRECT_LOCATOR_STORE_KEY__';
exports.REPORTING_REDIRECT_LOCATOR_STORE_KEY = REPORTING_REDIRECT_LOCATOR_STORE_KEY;
const UI_SETTINGS_SEARCH_INCLUDE_FROZEN = 'search:includeFrozen';
exports.UI_SETTINGS_SEARCH_INCLUDE_FROZEN = UI_SETTINGS_SEARCH_INCLUDE_FROZEN;
const UI_SETTINGS_CUSTOM_PDF_LOGO = 'xpackReporting:customPdfLogo';
exports.UI_SETTINGS_CUSTOM_PDF_LOGO = UI_SETTINGS_CUSTOM_PDF_LOGO;
const UI_SETTINGS_DATEFORMAT_TZ = 'dateFormat:tz';

// Licenses
exports.UI_SETTINGS_DATEFORMAT_TZ = UI_SETTINGS_DATEFORMAT_TZ;
const LICENSE_TYPE_TRIAL = 'trial';
exports.LICENSE_TYPE_TRIAL = LICENSE_TYPE_TRIAL;
const LICENSE_TYPE_BASIC = 'basic';
exports.LICENSE_TYPE_BASIC = LICENSE_TYPE_BASIC;
const LICENSE_TYPE_CLOUD_STANDARD = 'standard';
exports.LICENSE_TYPE_CLOUD_STANDARD = LICENSE_TYPE_CLOUD_STANDARD;
const LICENSE_TYPE_GOLD = 'gold';
exports.LICENSE_TYPE_GOLD = LICENSE_TYPE_GOLD;
const LICENSE_TYPE_PLATINUM = 'platinum';
exports.LICENSE_TYPE_PLATINUM = LICENSE_TYPE_PLATINUM;
const LICENSE_TYPE_ENTERPRISE = 'enterprise';
exports.LICENSE_TYPE_ENTERPRISE = LICENSE_TYPE_ENTERPRISE;
const REPORTING_SYSTEM_INDEX = '.reporting';
exports.REPORTING_SYSTEM_INDEX = REPORTING_SYSTEM_INDEX;
const JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = 'xpack.reporting.jobCompletionNotifications';

/**
 * A way to get the client side route for the reporting redirect app.
 *
 * TODO: Add a job ID and a locator to use so that we can redirect without expecting state to
 * be injected to the page
 */
exports.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY;
const getRedirectAppPath = () => {
  return '/app/reportingRedirect';
};
exports.getRedirectAppPath = getRedirectAppPath;
const ILM_POLICY_NAME = 'kibana-reporting';

// Usage counter types
exports.ILM_POLICY_NAME = ILM_POLICY_NAME;
const API_USAGE_COUNTER_TYPE = 'reportingApi';
exports.API_USAGE_COUNTER_TYPE = API_USAGE_COUNTER_TYPE;
const API_USAGE_ERROR_TYPE = 'reportingApiError';

// Management UI route
exports.API_USAGE_ERROR_TYPE = API_USAGE_ERROR_TYPE;
const REPORTING_MANAGEMENT_HOME = '/app/management/insightsAndAlerting/reporting';

/*
 * JobStatus:
 *  - Begins as 'pending'
 *  - Changes to 'processing` when the job is claimed
 *  - Then 'completed' | 'failed' when execution is done
 * If the job needs a retry, it reverts back to 'pending'.
 */
exports.REPORTING_MANAGEMENT_HOME = REPORTING_MANAGEMENT_HOME;
let JOB_STATUS; // Job params require a `version` field as of 7.15.0. For older jobs set with
// automation that have no version value in the job params, we assume the
// intended version is 7.14.0
exports.JOB_STATUS = JOB_STATUS;
(function (JOB_STATUS) {
  JOB_STATUS["PENDING"] = "pending";
  JOB_STATUS["PROCESSING"] = "processing";
  JOB_STATUS["COMPLETED"] = "completed";
  JOB_STATUS["FAILED"] = "failed";
  JOB_STATUS["WARNINGS"] = "completed_with_warnings";
})(JOB_STATUS || (exports.JOB_STATUS = JOB_STATUS = {}));
const UNVERSIONED_VERSION = '7.14.0';
exports.UNVERSIONED_VERSION = UNVERSIONED_VERSION;