"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasSetupPrivileges = getHasSetupPrivileges;
var _common = require("@kbn/fleet-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasSetupPrivileges({
  securityPluginStart,
  request
}) {
  // If we have a license which doesn't enable security, or we're a legacy user we shouldn't disable any ui capabilities
  if (!securityPluginStart.authz.mode.useRbacForRequest(request)) {
    return true;
  }
  const {
    hasAllRequested
  } = await securityPluginStart.authz.checkPrivilegesWithRequest(request).globally({
    elasticsearch: {
      cluster: ['manage', 'monitor'],
      index: {
        'profiling-*': ['read']
      }
    },
    kibana: [securityPluginStart.authz.actions.api.get(`${_common.PLUGIN_ID}-all`), securityPluginStart.authz.actions.api.get(`${_common.INTEGRATIONS_PLUGIN_ID}-all`)]
  });
  return hasAllRequested;
}