"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTable = HostsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _label_with_hint = require("../../../components/label_with_hint");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sorting = {
  sort: {
    field: 'hostName',
    direction: 'desc'
  }
};
function HostsTable({
  data = [],
  hasDistinctProbabilisticValues
}) {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo
  } = query;
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  function onTableChange({
    page: {
      index
    }
  }) {
    setPagination({
      pageIndex: index
    });
  }
  const probabilisticValuesCountPerProjectId = data.reduce((acc, curr) => {
    var _acc$projectId;
    const projectId = curr.projectId;
    const currentCount = (_acc$projectId = acc[projectId]) !== null && _acc$projectId !== void 0 ? _acc$projectId : 0;
    return {
      ...acc,
      [projectId]: currentCount + 1
    };
  }, {});
  const columns = (0, _react.useMemo)(() => [...(hasDistinctProbabilisticValues ? [{
    field: 'distinctProbabilisticWarning',
    width: '30',
    name: '',
    sortable: true,
    render: (_, item) => {
      if (probabilisticValuesCountPerProjectId[item.projectId] > 1) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.distinctProbabilisticValues', {
            defaultMessage: "We've identified distinct probabilistic profiling values for the same project"
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "warning"
        }));
      }
    }
  }] : []), {
    field: 'projectId',
    width: '100',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.projectId', {
      defaultMessage: 'Project ID'
    }),
    sortable: true
  }, {
    field: 'hostName',
    name: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
      label: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.host', {
        defaultMessage: 'Host'
      }),
      hint: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.host.hint', {
        defaultMessage: 'host.name[host.id]'
      }),
      labelSize: "xs",
      labelStyle: {
        fontWeight: 700
      },
      iconSize: "s"
    }),
    sortable: true,
    render: (_, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": `hostId_${item.hostId}`,
        className: "eui-textTruncate",
        href: profilingRouter.link('/flamegraphs/flamegraph', {
          query: {
            rangeFrom,
            rangeTo,
            kuery: `${'host.id'}: "${item.hostId}"`
          }
        })
      }, `${item.hostName} [${item.hostId}]`);
    }
  }, {
    field: 'probabilisticValues',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.probabilisticValues', {
      defaultMessage: 'Probabilistic Profiling values'
    }),
    sortable: true,
    render: probabilisticValues => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s"
      }, probabilisticValues.map((value, index) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          key: index,
          grow: false
        }, value.date ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.probabilisticProfilingValues', {
            defaultMessage: 'Introduced on {date}',
            values: {
              date: (0, _common.asAbsoluteDateTime)(value.date)
            }
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          isDisabled: index > 0
        }, value.value)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          isDisabled: index > 0
        }, value.value));
      }));
    }
  }, {
    field: 'totalMetricsSize',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.metricsData', {
      defaultMessage: 'Metrics data'
    }),
    sortable: true,
    width: '200',
    render: size => (0, _common.asDynamicBytes)(size)
  }, {
    field: 'totalEventsSize',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.samplesData', {
      defaultMessage: 'Samples data'
    }),
    sortable: true,
    width: '200',
    render: size => (0, _common.asDynamicBytes)(size)
  }, {
    field: 'totalSize',
    name: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
      label: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.totalData', {
        defaultMessage: 'Total data'
      }),
      hint: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.totalData.hint', {
        defaultMessage: 'The combined value of Universal Profiling metrics and samples.'
      }),
      labelSize: "xs",
      labelStyle: {
        fontWeight: 700
      },
      iconSize: "s"
    }),
    sortable: true,
    width: '200',
    render: size => (0, _common.asDynamicBytes)(size)
  }], [hasDistinctProbabilisticValues, probabilisticValuesCountPerProjectId, profilingRouter, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: data,
    columns: columns,
    sorting: sorting,
    pagination: {
      pageSize: 10,
      showPerPageOptions: false,
      ...pagination
    },
    onTableChange: onTableChange
  });
}