"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = Settings;
var _eui = require("@elastic/eui");
var _public = require("@kbn/advanced-settings-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/observability-plugin/common");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _bottom_bar_actions = require("./bottom_bar_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const co2Settings = [_common.profilingCo2PerKWH, _common.profilingDatacenterPUE, _common.profilingPervCPUWattX86, _common.profilingPervCPUWattArm64];
const costSettings = [_common.profilingAWSCostDiscountRate, _common.profilingCostPervCPUPerHour];
function Settings() {
  const trackProfilingEvent = (0, _public2.useUiTracker)({
    app: 'profiling'
  });
  const {
    start: {
      core: {
        docLinks,
        notifications
      }
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const {
    handleFieldChange,
    settingsEditableConfig,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _public2.useEditableSettings)('profiling', [...co2Settings, ...costSettings]);
  async function handleSave() {
    try {
      const reloadPage = Object.keys(unsavedChanges).some(key => {
        return settingsEditableConfig[key].requiresPageReload;
      });
      await saveAll();
      trackProfilingEvent({
        metric: 'general_settings_save'
      });
      if (reloadPage) {
        window.location.reload();
      }
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.profiling.settings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    hideSearchBar: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.settings.title', {
    defaultMessage: 'Advanced Settings'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), [{
    label: _i18n.i18n.translate('xpack.profiling.settings.co2Section', {
      defaultMessage: 'Custom CO2 settings'
    }),
    description: {
      title: _i18n.i18n.translate('xpack.profiling.settings.co2.title', {
        defaultMessage: 'The Universal Profiling host agent can detect if your machine is running on AWS, Azure, or Google Cloud Platform.'
      }),
      subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.settings.co2.subtitle",
        defaultMessage: "For machines running on AWS, Universal Profiling applies the appropriate {regionalCarbonIntensityLink} for your instance's AWS region and the current AWS data center {pue}.",
        values: {
          regionalCarbonIntensityLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingSettingsLink",
            href: "https://ela.st/grid-datasheet",
            target: "_blank"
          }, _i18n.i18n.translate('xpack.profiling.settings.co2.subtitle.link', {
            defaultMessage: 'regional carbon intensity'
          })),
          pue: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.profiling.settings.co2.subtitle.pue', {
            defaultMessage: 'PUE'
          }))
        }
      }),
      text: _i18n.i18n.translate('xpack.profiling.settings.co2.text', {
        defaultMessage: 'For all other configurations, Universal Profiling uses the following default configurations. You can update these configurations as needed.'
      })
    },
    settings: co2Settings
  }, {
    label: _i18n.i18n.translate('xpack.profiling.settings.costSection', {
      defaultMessage: 'Custom cost settings'
    }),
    description: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.settings.cost.title",
        defaultMessage: "Universal Profiling sets the cost for AWS configurations using the {awsPriceList} for your EC2 instance type.",
        values: {
          awsPriceList: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingSettingsLink",
            href: "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/Welcome.html#Welcome_AWS_Price_List_Service",
            target: "_blank"
          }, _i18n.i18n.translate('xpack.profiling.settings.cost.subtitle.link', {
            defaultMessage: 'AWS price list'
          }))
        }
      })
    },
    settings: costSettings
  }].map(item => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    key: item.label,
    grow: false,
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, item.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, item.description ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, item.description.title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, item.description.title)), item.description.subtitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, item.description.subtitle)), item.description.text && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, item.description.text)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, item.settings.map(settingKey => {
    const editableConfig = settingsEditableConfig[settingKey];
    return /*#__PURE__*/_react.default.createElement(_public.LazyField, {
      key: settingKey,
      setting: editableConfig,
      handleChange: handleFieldChange,
      enableSaving: true,
      docLinks: docLinks.links,
      toasts: notifications.toasts,
      unsavedChanges: unsavedChanges[settingKey]
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.profiling.settings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length
  })));
}