"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEmbeddables = registerEmbeddables;
var _public = require("@kbn/observability-shared-plugin/public");
var _embeddable_flamegraph_factory = require("./flamegraph/embeddable_flamegraph_factory");
var _embeddable_functions_factory = require("./functions/embeddable_functions_factory");
var _embeddable_search_bar_factory = require("./search_bar/embeddable_search_bar_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerEmbeddables(embeddable, getProfilingEmbeddableDependencies) {
  embeddable.registerEmbeddableFactory(_public.EMBEDDABLE_FLAMEGRAPH, new _embeddable_flamegraph_factory.EmbeddableFlamegraphFactory(getProfilingEmbeddableDependencies));
  embeddable.registerEmbeddableFactory(_public.EMBEDDABLE_FUNCTIONS, new _embeddable_functions_factory.EmbeddableFunctionsFactory(getProfilingEmbeddableDependencies));
  embeddable.registerEmbeddableFactory(_public.EMBEDDABLE_PROFILING_SEARCH_BAR, new _embeddable_search_bar_factory.EmbeddableSearchBarFactory(getProfilingEmbeddableDependencies));
}