"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNFunctionsGrid = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _profilingUtils = require("@kbn/profiling-utils");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _cpu_label_with_hint = require("../cpu_label_with_hint");
var _frame_information_tooltip = require("../frame_information_window/frame_information_tooltip");
var _label_with_hint = require("../label_with_hint");
var _function_row = require("./function_row");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopNFunctionsGrid = /*#__PURE__*/(0, _react.forwardRef)(({
  topNFunctions,
  comparisonTopNFunctions,
  totalSeconds,
  isDifferentialView,
  baselineScaleFactor,
  comparisonScaleFactor,
  onFrameClick,
  onScroll,
  showDiffColumn = false,
  pageIndex,
  onChangePage,
  sortField,
  sortDirection,
  onChangeSort,
  dataTestSubj = 'topNFunctionsGrid',
  isEmbedded = false
}, ref) => {
  const {
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const shouldUseLegacyCo2Calculation = core.uiSettings.get(_common.profilingUseLegacyCo2Calculation);
  const [selectedRow, setSelectedRow] = (0, _react.useState)();
  const trackProfilingEvent = (0, _public.useUiTracker)({
    app: 'profiling'
  });
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  function onSort(newSortingColumns) {
    const lastItem = (0, _lodash.last)(newSortingColumns);
    if (lastItem) {
      onChangeSort(lastItem);
    }
  }
  const totalCount = (0, _react.useMemo)(() => {
    if (!topNFunctions || !topNFunctions.TotalCount) {
      return 0;
    }
    return topNFunctions.TotalCount;
  }, [topNFunctions]);
  const rows = (0, _react.useMemo)(() => {
    return (0, _utils.getFunctionsRows)({
      baselineScaleFactor,
      comparisonScaleFactor,
      comparisonTopNFunctions,
      topNFunctions,
      totalSeconds,
      calculateImpactEstimates
    });
  }, [baselineScaleFactor, calculateImpactEstimates, comparisonScaleFactor, comparisonTopNFunctions, topNFunctions, totalSeconds]);
  const sortedRows = (0, _react.useMemo)(() => {
    switch (sortField) {
      case _profilingUtils.TopNFunctionSortField.Frame:
        return (0, _lodash.orderBy)(rows, row => (0, _profilingUtils.getCalleeFunction)(row.frame), sortDirection);
      case _profilingUtils.TopNFunctionSortField.SelfCPU:
        return (0, _lodash.orderBy)(rows, row => row.selfCPUPerc, sortDirection);
      case _profilingUtils.TopNFunctionSortField.TotalCPU:
        return (0, _lodash.orderBy)(rows, row => row.totalCPUPerc, sortDirection);
      case _profilingUtils.TopNFunctionSortField.AnnualizedCo2:
        return (0, _lodash.orderBy)(rows, row => {
          var _row$impactEstimates;
          return shouldUseLegacyCo2Calculation ? (_row$impactEstimates = row.impactEstimates) === null || _row$impactEstimates === void 0 ? void 0 : _row$impactEstimates.totalCPU.annualizedCo2 : row.totalAnnualCO2kgs;
        }, sortDirection);
      case _profilingUtils.TopNFunctionSortField.AnnualizedDollarCost:
        return (0, _lodash.orderBy)(rows, row => {
          var _row$impactEstimates2;
          return shouldUseLegacyCo2Calculation ? (_row$impactEstimates2 = row.impactEstimates) === null || _row$impactEstimates2 === void 0 ? void 0 : _row$impactEstimates2.totalCPU.annualizedDollarCost : row.totalAnnualCostUSD;
        }, sortDirection);
      default:
        return (0, _lodash.orderBy)(rows, sortField, sortDirection);
    }
  }, [rows, shouldUseLegacyCo2Calculation, sortDirection, sortField]);
  const {
    columns,
    leadingControlColumns
  } = (0, _react.useMemo)(() => {
    const gridColumns = [{
      id: _profilingUtils.TopNFunctionSortField.Rank,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      initialWidth: isDifferentialView ? 50 : 90,
      displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.rankColumnLabel', {
        defaultMessage: 'Rank'
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.Frame,
      actions: {
        showHide: false
      },
      displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.functionColumnLabel', {
        defaultMessage: 'Function'
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.Samples,
      initialWidth: isDifferentialView ? 100 : 200,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
        label: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel', {
          defaultMessage: 'Samples'
        }),
        hint: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel.hint', {
          defaultMessage: 'Estimated values'
        }),
        labelSize: "s",
        labelStyle: {
          fontWeight: 700
        },
        iconSize: "s"
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.SelfCPU,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      initialWidth: isDifferentialView ? 100 : 200,
      display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
        type: "self",
        labelSize: "s",
        labelStyle: {
          fontWeight: 700
        },
        iconSize: "s"
      })
    }, {
      id: _profilingUtils.TopNFunctionSortField.TotalCPU,
      schema: 'numeric',
      actions: {
        showHide: false
      },
      initialWidth: isDifferentialView ? 100 : 200,
      display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
        type: "total",
        labelSize: "s",
        labelStyle: {
          fontWeight: 700
        },
        iconSize: "s"
      })
    }];
    const gridLeadingControlColumns = [];
    if (showDiffColumn) {
      gridColumns.push({
        initialWidth: 60,
        id: _profilingUtils.TopNFunctionSortField.Diff,
        actions: {
          showHide: false
        },
        displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.diffColumnLabel', {
          defaultMessage: 'Diff'
        })
      });
    }
    if (!isDifferentialView) {
      gridColumns.push({
        id: _profilingUtils.TopNFunctionSortField.AnnualizedCo2,
        actions: {
          showHide: false
        },
        initialWidth: isDifferentialView ? 100 : 200,
        schema: 'numeric',
        display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
          label: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedCo2', {
            defaultMessage: 'Annualized CO2'
          }),
          hint: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedCo2.hint', {
            defaultMessage: 'Indicates the CO2 emission of the function and any functions called by it.'
          }),
          labelSize: "s",
          labelStyle: {
            fontWeight: 700
          },
          iconSize: "s"
        })
      }, {
        id: _profilingUtils.TopNFunctionSortField.AnnualizedDollarCost,
        schema: 'numeric',
        actions: {
          showHide: false
        },
        initialWidth: isDifferentialView ? 100 : 200,
        display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
          label: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedDollarCost', {
            defaultMessage: `Annualized dollar cost`
          }),
          hint: _i18n.i18n.translate('xpack.profiling.functionsView.annualizedDollarCost.hint', {
            defaultMessage: `Indicates the Dollar cost of the function and any functions called by it.`
          }),
          labelSize: "s",
          labelStyle: {
            fontWeight: 700
          },
          iconSize: "s"
        })
      });
      gridLeadingControlColumns.push({
        id: 'actions',
        width: 40,
        headerCellRender() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.span.controlsLabel', {
            defaultMessage: 'Controls'
          })));
        },
        rowCellRender: function RowCellRender({
          rowIndex
        }) {
          function handleOnClick() {
            trackProfilingEvent({
              metric: 'topN_function_details_click'
            });
            setSelectedRow(sortedRows[rowIndex]);
          }
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "data-test-subj": "profilingTopNFunctionsGridButton",
            "aria-label": _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.euiButtonIcon.showActionsLabel', {
              defaultMessage: 'Show actions'
            }),
            iconType: "expand",
            color: "text",
            onClick: handleOnClick
          });
        }
      });
    }
    return {
      columns: gridColumns,
      leadingControlColumns: gridLeadingControlColumns
    };
  }, [isDifferentialView, sortedRows, showDiffColumn, trackProfilingEvent]);
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(columns.map(({
    id
  }) => id));
  function RenderCellValue({
    rowIndex,
    columnId,
    setCellProps
  }) {
    const data = sortedRows[rowIndex];
    if (data) {
      return /*#__PURE__*/_react.default.createElement(_function_row.FunctionRow, {
        functionRow: data,
        columnId: columnId,
        totalCount: totalCount,
        onFrameClick: onFrameClick,
        setCellProps: setCellProps
      });
    }
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "data-test-subj": dataTestSubj,
    ref: ref,
    "aria-label": _i18n.i18n.translate('xpack.profiling.topNFunctionsGrid.euiDataGrid.topNFunctionsLabel', {
      defaultMessage: 'TopN functions'
    }),
    columns: columns,
    columnVisibility: {
      visibleColumns,
      setVisibleColumns
    },
    rowCount: sortedRows.length > 100 ? 100 : sortedRows.length,
    renderCellValue: RenderCellValue,
    sorting: {
      columns: [{
        id: sortField,
        direction: sortDirection
      }],
      onSort
    },
    leadingControlColumns: leadingControlColumns,
    pagination: {
      pageIndex,
      pageSize: 50,
      // Left it empty on purpose as it is a required property on the pagination
      onChangeItemsPerPage: () => {},
      onChangePage,
      pageSizeOptions: []
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    toolbarVisibility: {
      showColumnSelector: false,
      showKeyboardShortcuts: !isDifferentialView,
      showDisplaySelector: !isDifferentialView,
      showFullScreenSelector: !isDifferentialView,
      showSortSelector: false
    },
    virtualizationOptions: {
      onScroll
    }
  }), selectedRow && /*#__PURE__*/_react.default.createElement(_frame_information_tooltip.FrameInformationTooltip, {
    onClose: () => {
      setSelectedRow(undefined);
    },
    frame: {
      addressOrLine: selectedRow.frame.AddressOrLine,
      countExclusive: selectedRow.selfCPU,
      countInclusive: selectedRow.totalCPU,
      exeFileName: selectedRow.frame.ExeFileName,
      fileID: selectedRow.frame.FileID,
      frameType: selectedRow.frame.FrameType,
      functionName: selectedRow.frame.FunctionName,
      sourceFileName: selectedRow.frame.SourceFilename,
      sourceLine: selectedRow.frame.SourceLine,
      selfAnnualCO2Kgs: selectedRow.selfAnnualCO2kgs,
      totalAnnualCO2Kgs: selectedRow.totalAnnualCO2kgs,
      selfAnnualCostUSD: selectedRow.selfAnnualCostUSD,
      totalAnnualCostUSD: selectedRow.totalAnnualCostUSD
    },
    totalSeconds: totalSeconds,
    totalSamples: totalCount,
    showAIAssistant: !isEmbedded,
    showSymbolsStatus: !isEmbedded
  }));
});
exports.TopNFunctionsGrid = TopNFunctionsGrid;