"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraph = FlameGraph;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _get_flamegraph_model = require("../../utils/get_flamegraph_model");
var _frame_information_tooltip = require("../frame_information_window/frame_information_tooltip");
var _flamegraph_tooltip = require("./flamegraph_tooltip");
var _flame_graph_legend = require("./flame_graph_legend");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraph({
  id,
  comparisonMode,
  primaryFlamegraph,
  comparisonFlamegraph,
  baseline,
  comparison,
  searchText,
  onChangeSearchText,
  isEmbedded = false
}) {
  var _primaryFlamegraph$To;
  const [showInformationWindow, setShowInformationWindow] = (0, _react.useState)(false);
  function toggleShowInformationWindow() {
    setShowInformationWindow(prev => !prev);
  }
  const theme = (0, _eui.useEuiTheme)();
  const trackProfilingEvent = (0, _public.useUiTracker)({
    app: 'profiling'
  });
  const columnarData = (0, _react.useMemo)(() => {
    return (0, _get_flamegraph_model.getFlamegraphModel)({
      primaryFlamegraph,
      comparisonFlamegraph,
      colorSuccess: theme.euiTheme.colors.success,
      colorDanger: theme.euiTheme.colors.danger,
      colorNeutral: theme.euiTheme.colors.lightShade,
      comparisonMode,
      baseline,
      comparison
    });
  }, [primaryFlamegraph, comparisonFlamegraph, theme.euiTheme.colors.success, theme.euiTheme.colors.danger, theme.euiTheme.colors.lightShade, comparisonMode, baseline, comparison]);
  const chartTheme = {
    chartMargins: {
      top: 0,
      left: 0,
      bottom: 0,
      right: 0
    },
    chartPaddings: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    tooltip: {
      maxWidth: 500
    }
  };
  const totalSamples = columnarData.viewModel.value[0];
  const [highlightedVmIndex, setHighlightedVmIndex] = (0, _react.useState)(undefined);
  const selected = primaryFlamegraph && highlightedVmIndex !== undefined ? {
    fileID: primaryFlamegraph.FileID[highlightedVmIndex],
    frameType: primaryFlamegraph.FrameType[highlightedVmIndex],
    exeFileName: primaryFlamegraph.ExeFilename[highlightedVmIndex],
    addressOrLine: primaryFlamegraph.AddressOrLine[highlightedVmIndex],
    functionName: primaryFlamegraph.FunctionName[highlightedVmIndex],
    sourceFileName: primaryFlamegraph.SourceFilename[highlightedVmIndex],
    sourceLine: primaryFlamegraph.SourceLine[highlightedVmIndex],
    countInclusive: primaryFlamegraph.CountInclusive[highlightedVmIndex],
    countExclusive: primaryFlamegraph.CountExclusive[highlightedVmIndex],
    selfAnnualCO2Kgs: primaryFlamegraph.SelfAnnualCO2KgsItems[highlightedVmIndex],
    totalAnnualCO2Kgs: primaryFlamegraph.TotalAnnualCO2KgsItems[highlightedVmIndex],
    selfAnnualCostUSD: primaryFlamegraph.SelfAnnualCostsUSDItems[highlightedVmIndex],
    totalAnnualCostUSD: primaryFlamegraph.TotalAnnualCostsUSDItems[highlightedVmIndex]
  } : undefined;
  (0, _react.useEffect)(() => {
    setHighlightedVmIndex(undefined);
  }, [columnarData.key]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, columnarData.viewModel.label.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    key: columnarData.key
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: chartTheme,
    onElementClick: elements => {
      const selectedElement = elements[0];
      if (Number.isNaN(selectedElement === null || selectedElement === void 0 ? void 0 : selectedElement.vmIndex)) {
        setHighlightedVmIndex(undefined);
      } else {
        setHighlightedVmIndex(selectedElement.vmIndex);
      }
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    actions: [{
      label: '',
      onSelect: () => {}
    }],
    customTooltip: props => {
      if (!primaryFlamegraph) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
      const valueIndex = props.values[0].valueAccessor;
      const label = primaryFlamegraph.Label[valueIndex];
      const countInclusive = primaryFlamegraph.CountInclusive[valueIndex];
      const countExclusive = primaryFlamegraph.CountExclusive[valueIndex];
      const totalSeconds = primaryFlamegraph.TotalSeconds;
      const nodeID = primaryFlamegraph.ID[valueIndex];
      const inline = primaryFlamegraph.Inline[valueIndex];
      const comparisonNode = columnarData.comparisonNodesById[nodeID];
      const parentLabel = inline ?
      // If it's an inline frame, look up for its parent frame
      primaryFlamegraph.Label[primaryFlamegraph.Edges.findIndex(edge => edge.includes(valueIndex))] : undefined;
      return /*#__PURE__*/_react.default.createElement(_flamegraph_tooltip.FlameGraphTooltip, {
        annualCO2KgsInclusive: primaryFlamegraph.TotalAnnualCO2KgsItems[valueIndex],
        annualCostsUSDInclusive: primaryFlamegraph.TotalAnnualCostsUSDItems[valueIndex],
        baselineScaleFactor: baseline,
        comparisonAnnualCO2KgsInclusive: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.TotalAnnualCO2KgsItems[valueIndex],
        comparisonAnnualCostsUSDInclusive: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.TotalAnnualCostsUSDItems[valueIndex],
        comparisonCountExclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.CountExclusive,
        comparisonCountInclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.CountInclusive,
        comparisonScaleFactor: comparison,
        comparisonTotalSamples: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.CountInclusive[0],
        comparisonTotalSeconds: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.TotalSeconds,
        countExclusive: countExclusive,
        countInclusive: countInclusive,
        isRoot: valueIndex === 0,
        label: label,
        onShowMoreClick: () => {
          trackProfilingEvent({
            metric: 'flamegraph_node_details_click'
          });
          toggleShowInformationWindow();
          setHighlightedVmIndex(valueIndex);
        },
        totalSamples: totalSamples,
        totalSeconds: totalSeconds,
        inline: inline,
        parentLabel: parentLabel
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Flame, {
    id: id,
    columnarData: columnarData.viewModel,
    valueAccessor: d => d.value,
    valueFormatter: value => `${value}`,
    animation: {
      duration: 100
    },
    controlProviderCallback: {},
    search: searchText ? {
      text: searchText
    } : undefined,
    onSearchTextChange: onChangeSearchText
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_flame_graph_legend.FlameGraphLegend, {
    legendItems: columnarData.legendItems,
    asScale: !!comparisonFlamegraph
  }))), showInformationWindow && /*#__PURE__*/_react.default.createElement(_frame_information_tooltip.FrameInformationTooltip, {
    onClose: toggleShowInformationWindow,
    frame: selected,
    totalSeconds: (_primaryFlamegraph$To = primaryFlamegraph === null || primaryFlamegraph === void 0 ? void 0 : primaryFlamegraph.TotalSeconds) !== null && _primaryFlamegraph$To !== void 0 ? _primaryFlamegraph$To : 0,
    totalSamples: totalSamples,
    showSymbolsStatus: !isEmbedded
  }));
}