"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseContext = void 0;
exports.LicenseProvider = LicenseProvider;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _profiling_app_page_template = require("../../profiling_app_page_template");
var _license_prompt = require("../../license_prompt");
var _use_profiling_dependencies = require("../profiling_dependencies/use_profiling_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicenseContext = /*#__PURE__*/_react.default.createContext(undefined);
exports.LicenseContext = LicenseContext;
function LicenseProvider({
  children
}) {
  const {
    license$
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().setup.licensing;
  const license = (0, _useObservable.default)(license$);
  // if license is not loaded yet, consider it valid
  const hasInvalidLicense = (license === null || license === void 0 ? void 0 : license.isActive) === false;

  // if license is invalid show an error message
  if (hasInvalidLicense) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      hideSearchBar: true,
      tabs: []
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, null));
  }

  // render rest of application and pass down license via context
  return /*#__PURE__*/_react.default.createElement(LicenseContext.Provider, {
    value: license,
    children: children
  });
}