"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privilegesCheckRoute = void 0;
var _constants = require("../../../common/constants");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privilegesCheckRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'internal',
    path: '/internal/osquery/privileges_check',
    options: {
      tags: [`access:${_common.PLUGIN_ID}-readLiveQueries`]
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {}
  }, async (context, request, response) => {
    if (osqueryContext.security.authz.mode.useRbacForRequest(request)) {
      const checkPrivileges = osqueryContext.security.authz.checkPrivilegesDynamicallyWithRequest(request);
      const {
        hasAllRequested
      } = await checkPrivileges({
        elasticsearch: {
          cluster: [],
          index: {
            [`logs-${_common.OSQUERY_INTEGRATION_NAME}.result*`]: ['read']
          }
        }
      });
      return response.ok({
        body: `${hasAllRequested}`
      });
    }
    return response.ok({
      body: 'true'
    });
  });
};
exports.privilegesCheckRoute = privilegesCheckRoute;