"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionResultsSummary = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_id_to_name = require("../agents/agent_id_to_name");
var _use_action_results = require("./use_action_results");
var _search_strategy = require("../../common/search_strategy");
var _use_action_privileges = require("./use_action_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderErrorMessage = error => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "shell",
  fontSize: "s",
  paddingSize: "none",
  transparentBackground: true
}, error);
const ActionResultsSummaryComponent = ({
  actionId,
  expirationDate,
  agentIds,
  error,
  startDate
}) => {
  const [pageIndex] = (0, _react.useState)(0);
  const [pageSize] = (0, _react.useState)(50);
  const expired = (0, _react.useMemo)(() => !expirationDate ? false : new Date(expirationDate) < new Date(), [expirationDate]);
  const [isLive, setIsLive] = (0, _react.useState)(true);
  const {
    data: hasActionResultsPrivileges
  } = (0, _use_action_privileges.useActionResultsPrivileges)();
  const {
    // @ts-expect-error update types
    data: {
      aggregations,
      edges
    }
  } = (0, _use_action_results.useActionResults)({
    actionId,
    startDate,
    activePage: pageIndex,
    agentIds,
    limit: pageSize,
    direction: _search_strategy.Direction.asc,
    sortField: '@timestamp',
    isLive,
    skip: !hasActionResultsPrivileges
  });
  (0, _react.useEffect)(() => {
    if (error) {
      edges.forEach(edge => {
        if (edge.fields) {
          edge.fields['error.skipped'] = edge.fields.error = [error];
        }
      });
    } else if (expired) {
      edges.forEach(edge => {
        var _edge$fields;
        if (!((_edge$fields = edge.fields) !== null && _edge$fields !== void 0 && _edge$fields.completed_at) && edge.fields) {
          edge.fields['error.keyword'] = edge.fields.error = [_i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.expiredErrorText', {
            defaultMessage: 'The action request timed out.'
          })];
        }
      });
    }
  }, [edges, error, expired]);
  const renderAgentIdColumn = (0, _react.useCallback)(agentId => /*#__PURE__*/_react.default.createElement(_agent_id_to_name.AgentIdToName, {
    agentId: agentId
  }), []);
  const renderRowsColumn = (0, _react.useCallback)(rowsCount => rowsCount !== null && rowsCount !== void 0 ? rowsCount : '-', []);
  const renderStatusColumn = (0, _react.useCallback)((_, item) => {
    if (item.fields['error.skipped']) {
      return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.skippedStatusText', {
        defaultMessage: 'skipped'
      });
    }
    if (!item.fields.completed_at) {
      return expired ? _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.expiredStatusText', {
        defaultMessage: 'expired'
      }) : _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.pendingStatusText', {
        defaultMessage: 'pending'
      });
    }
    if (item.fields['error.keyword']) {
      return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.errorStatusText', {
        defaultMessage: 'error'
      });
    }
    return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.successStatusText', {
      defaultMessage: 'success'
    });
  }, [expired]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'status',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    render: renderStatusColumn
  }, {
    field: 'fields.agent_id[0]',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.agentIdColumnTitle', {
      defaultMessage: 'Agent Id'
    }),
    truncateText: true,
    render: renderAgentIdColumn
  }, {
    field: '_source.action_response.osquery.count',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.resultRowsNumberColumnTitle', {
      defaultMessage: 'Number of result rows'
    }),
    render: renderRowsColumn
  }, {
    field: 'fields.error[0]',
    name: _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.table.errorColumnTitle', {
      defaultMessage: 'Error'
    }),
    render: renderErrorMessage
  }], [renderAgentIdColumn, renderRowsColumn, renderStatusColumn]);
  const pagination = (0, _react.useMemo)(() => ({
    initialPageSize: 20,
    pageSizeOptions: [10, 20, 50, 100]
  }), []);
  (0, _react.useEffect)(() => {
    setIsLive(() => {
      if (!(agentIds !== null && agentIds !== void 0 && agentIds.length) || expired || error) return false;
      return aggregations.totalResponded !== (agentIds === null || agentIds === void 0 ? void 0 : agentIds.length);
    });
  }, [agentIds === null || agentIds === void 0 ? void 0 : agentIds.length, aggregations.totalResponded, error, expired]);
  return edges.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLive,
    items: edges,
    columns: columns,
    pagination: pagination
  }) : null;
};
const ActionResultsSummary = /*#__PURE__*/_react.default.memo(ActionResultsSummaryComponent);
exports.ActionResultsSummary = ActionResultsSummary;