"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElastichsearchQueryOrThrow = getElastichsearchQueryOrThrow;
exports.parseIndex = parseIndex;
var _esQuery = require("@kbn/es-query");
var _errors = require("../../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElastichsearchQueryOrThrow(kuery = '') {
  try {
    return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery));
  } catch (err) {
    throw new _errors.InvalidTransformError(`Invalid KQL: ${kuery}`);
  }
}
function parseIndex(index) {
  if (index.indexOf(',') === -1) {
    return index;
  }
  return index.split(',');
}