"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultSummaryTransformGenerator = void 0;
var _occurrences = require("./generators/occurrences");
var _timeslices_rolling = require("./generators/timeslices_rolling");
var _timeslices_calendar_aligned = require("./generators/timeslices_calendar_aligned");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DefaultSummaryTransformGenerator {
  generate(slo) {
    if (slo.budgetingMethod === 'occurrences') {
      return (0, _occurrences.generateSummaryTransformForOccurrences)(slo);
    } else if (slo.budgetingMethod === 'timeslices' && slo.timeWindow.type === 'rolling') {
      return (0, _timeslices_rolling.generateSummaryTransformForTimeslicesAndRolling)(slo);
    } else if (slo.budgetingMethod === 'timeslices' && slo.timeWindow.type === 'calendarAligned') {
      return (0, _timeslices_calendar_aligned.generateSummaryTransformForTimeslicesAndCalendarAligned)(slo);
    }
    throw new Error('Not supported SLO');
  }
}
exports.DefaultSummaryTransformGenerator = DefaultSummaryTransformGenerator;