"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.thresholdExplorerViewSavedObjectName = exports.threshold = void 0;
var _Either = require("fp-ts/lib/Either");
var _pipeable = require("fp-ts/lib/pipeable");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const thresholdExplorerViewSavedObjectName = 'threshold-explorer-view';
exports.thresholdExplorerViewSavedObjectName = thresholdExplorerViewSavedObjectName;
const getThresholdExplorerViewTitle = savedObject => (0, _pipeable.pipe)(_types.metricsExplorerViewSavedObjectRT.decode(savedObject), (0, _Either.fold)(() => `Threshold explorer view [id=${savedObject.id}]`, ({
  attributes: {
    name
  }
}) => name));
const threshold = {
  name: thresholdExplorerViewSavedObjectName,
  hidden: false,
  namespaceType: 'multiple-isolated',
  management: {
    defaultSearchField: 'name',
    displayName: 'threshold explorer view',
    getTitle: getThresholdExplorerViewTitle,
    icon: 'metricsApp',
    importableAndExportable: true
  },
  mappings: {
    dynamic: false,
    properties: {}
  }
};
exports.threshold = threshold;