"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosView = SlosView;
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_fetch_rules_for_slo = require("../../../hooks/slo/use_fetch_rules_for_slo");
var _use_fetch_active_alerts = require("../../../hooks/slo/use_fetch_active_alerts");
var _slos_card_view = require("./card_view/slos_card_view");
var _slo_list_empty = require("./slo_list_empty");
var _slo_list_error = require("./slo_list_error");
var _slo_list_items = require("./slo_list_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SlosView({
  isCompact,
  sloList,
  loading,
  error,
  sloView
}) {
  const sloIdsAndInstanceIds = sloList.map(slo => {
    var _slo$instanceId;
    return [slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE];
  });
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloIdsAndInstanceIds.map(item => item[0])
  });
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null);
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, null);
  }
  return sloView === 'cardView' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slos_card_view.SloListCardView, {
    sloList: sloList,
    loading: loading,
    error: error,
    cardsPerRow: isCompact ? '4' : '3',
    activeAlertsBySlo: activeAlertsBySlo,
    rulesBySlo: rulesBySlo
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_list_items.SloListItems, {
    sloList: sloList,
    activeAlertsBySlo: activeAlertsBySlo,
    rulesBySlo: rulesBySlo,
    error: error,
    loading: loading,
    isCompact: isCompact
  }));
}