"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListSearchBar = SloListSearchBar;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_create_data_view = require("../../../hooks/use_create_data_view");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SORT_OPTIONS = [{
  label: _i18n.i18n.translate('xpack.observability.slo.list.sortBy.sliValue', {
    defaultMessage: 'SLI value'
  }),
  type: 'sli_value'
}, {
  label: _i18n.i18n.translate('xpack.observability.slo.list.sortBy.sloStatus', {
    defaultMessage: 'SLO status'
  }),
  type: 'status'
}, {
  label: _i18n.i18n.translate('xpack.observability.slo.list.sortBy.errorBudgetConsumed', {
    defaultMessage: 'Error budget consumed'
  }),
  type: 'error_budget_consumed'
}, {
  label: _i18n.i18n.translate('xpack.observability.slo.list.sortBy.errorBudgetRemaining', {
    defaultMessage: 'Error budget remaining'
  }),
  type: 'error_budget_remaining'
}];
function SloListSearchBar({
  loading,
  onChangeQuery,
  onChangeSort,
  initialState
}) {
  var _selectedSort$label$t;
  const {
    data,
    dataViews,
    docLinks,
    http,
    notifications,
    storage,
    uiSettings,
    unifiedSearch
  } = (0, _kibana_react.useKibana)().services;
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: '.slo-observability.summary-*'
  });
  const [query, setQuery] = (0, _react.useState)(initialState.kqlQuery);
  const [isSortPopoverOpen, setSortPopoverOpen] = (0, _react.useState)(false);
  const [sortOptions, setSortOptions] = (0, _react.useState)(SORT_OPTIONS.map(option => ({
    ...option,
    checked: option.type === initialState.sort.by ? 'on' : undefined
  })));
  const selectedSort = sortOptions.find(option => option.checked === 'on');
  const handleToggleSortButton = () => setSortPopoverOpen(!isSortPopoverOpen);
  const handleChangeSort = newOptions => {
    setSortOptions(newOptions);
    setSortPopoverOpen(false);
    onChangeSort(newOptions.find(o => o.checked).type);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    appName: "Observability",
    bubbleSubmitEvent: false,
    deps: {
      data,
      dataViews,
      docLinks,
      http,
      notifications,
      storage,
      uiSettings,
      unifiedSearch
    },
    disableAutoFocus: true,
    onSubmit: value => {
      setQuery(String(value.query));
      onChangeQuery(String(value.query));
    },
    disableLanguageSwitcher: true,
    isDisabled: loading,
    autoSubmit: true,
    indexPatterns: dataView ? [dataView] : [],
    placeholder: _i18n.i18n.translate('xpack.observability.slo.list.search', {
      defaultMessage: 'Search your SLOs...'
    }),
    query: {
      query: String(query),
      language: 'kuery'
    },
    size: "s",
    onChange: value => setQuery(String(value.query))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 250
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      disabled: loading,
      iconType: "arrowDown",
      onClick: handleToggleSortButton,
      isSelected: isSortPopoverOpen
    }, _i18n.i18n.translate('xpack.observability.slo.list.sortByType', {
      defaultMessage: 'Sort by {type}',
      values: {
        type: (_selectedSort$label$t = selectedSort === null || selectedSort === void 0 ? void 0 : selectedSort.label.toLowerCase()) !== null && _selectedSort$label$t !== void 0 ? _selectedSort$label$t : ''
      }
    })),
    isOpen: isSortPopoverOpen,
    closePopover: handleToggleSortButton,
    panelPaddingSize: "none",
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 250
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.observability.slo.list.sortBy', {
    defaultMessage: 'Sort by'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: "always",
    options: sortOptions,
    onChange: handleChangeSort,
    isLoading: loading
  }, list => list))))))));
}