"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloItemActions = SloItemActions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _sloSchema = require("@kbn/slo-schema");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_clone_slo = require("../../../hooks/slo/use_clone_slo");
var _use_capabilities = require("../../../hooks/slo/use_capabilities");
var _kibana_react = require("../../../utils/kibana_react");
var _paths = require("../../../../common/locators/paths");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomShadowPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  ${props => props.shadow}
`;
function IconPanel({
  children,
  hasPanel
}) {
  const shadow = (0, _eui.useEuiShadow)('s');
  if (!hasPanel) return children;
  return /*#__PURE__*/_react.default.createElement(CustomShadowPanel, {
    color: "plain",
    element: "button",
    grow: false,
    paddingSize: "none",
    hasShadow: false,
    shadow: shadow
  }, children);
}
function SloItemActions({
  slo,
  isActionsPopoverOpen,
  setIsActionsPopoverOpen,
  setIsAddRuleFlyoutOpen,
  setDeleteConfirmationModalOpen,
  btnProps
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    share: {
      url: {
        locators
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const sloDetailsUrl = basePath.prepend(_paths.paths.observability.sloDetails(slo.id, slo.groupBy !== _sloSchema.ALL_VALUE && slo.instanceId ? slo.instanceId : undefined));
  const handleClickActions = () => {
    setIsActionsPopoverOpen(!isActionsPopoverOpen);
  };
  const handleViewDetails = () => {
    navigateToUrl(sloDetailsUrl);
  };
  const handleEdit = () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.sloEdit(slo.id)));
  };
  const navigateToClone = (0, _use_clone_slo.useCloneSlo)();
  const handleClone = () => {
    navigateToClone(slo);
  };
  const handleNavigateToRules = async () => {
    const locator = locators.get(_common.rulesLocatorID);
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      params: {
        sloId: slo.id
      }
    }, {
      replace: false
    });
  };
  const handleDelete = () => {
    setDeleteConfirmationModalOpen(true);
    setIsActionsPopoverOpen(false);
  };
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  const btn = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "o11ySloListItemButton",
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.item.actions.button', {
      defaultMessage: 'Actions'
    }),
    color: "text",
    disabled: !slo.summary,
    display: "empty",
    iconType: "boxesVertical",
    size: "s",
    onClick: handleClickActions
  }, btnProps));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: btnProps ? /*#__PURE__*/_react.default.createElement(IconPanel, {
      hasPanel: true
    }, btn) : btn,
    panelPaddingSize: "m",
    closePopover: handleClickActions,
    isOpen: isActionsPopoverOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "view",
      icon: "inspect",
      onClick: handleViewDetails,
      "data-test-subj": "sloActionsView"
    }, _i18n.i18n.translate('xpack.observability.slo.item.actions.details', {
      defaultMessage: 'Details'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      icon: "pencil",
      disabled: !hasWriteCapabilities,
      onClick: handleEdit,
      "data-test-subj": "sloActionsEdit"
    }, _i18n.i18n.translate('xpack.observability.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      icon: "bell",
      disabled: !hasWriteCapabilities,
      onClick: handleCreateRule,
      "data-test-subj": "sloActionsCreateRule"
    }, _i18n.i18n.translate('xpack.observability.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      icon: "gear",
      disabled: !hasWriteCapabilities,
      onClick: handleNavigateToRules,
      "data-test-subj": "sloActionsManageRules"
    }, _i18n.i18n.translate('xpack.observability.slo.item.actions.manageRules', {
      defaultMessage: 'Manage rules'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !hasWriteCapabilities,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloActionsClone"
    }, _i18n.i18n.translate('xpack.observability.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !hasWriteCapabilities,
      onClick: handleDelete,
      "data-test-subj": "sloActionsDelete"
    }, _i18n.i18n.translate('xpack.observability.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }))]
  }));
}