"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSectionFormValidation = useSectionFormValidation;
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSectionFormValidation({
  getFieldState,
  getValues,
  formState,
  watch
}) {
  let isIndicatorSectionValid = false;
  switch (watch('indicator.type')) {
    case 'sli.metric.custom':
      const isGoodParamsValid = () => {
        var _data$metrics;
        const data = getValues('indicator.params.good');
        const isEquationValid = !getFieldState('indicator.params.good.equation').invalid;
        const areMetricsValid = (0, _lodash.isObject)(data) && ((_data$metrics = data.metrics) !== null && _data$metrics !== void 0 ? _data$metrics : []).every(metric => {
          if (_sloSchema.metricCustomDocCountMetric.is(metric)) {
            return true;
          }
          if (_sloSchema.metricCustomBasicMetric.is(metric) && metric.field != null) {
            return true;
          }
          return false;
        });
        return isEquationValid && areMetricsValid;
      };
      const isTotalParamsValid = () => {
        var _data$metrics2;
        const data = getValues('indicator.params.total');
        const isEquationValid = !getFieldState('indicator.params.total.equation').invalid;
        const areMetricsValid = (0, _lodash.isObject)(data) && ((_data$metrics2 = data.metrics) !== null && _data$metrics2 !== void 0 ? _data$metrics2 : []).every(metric => {
          if (_sloSchema.metricCustomDocCountMetric.is(metric)) {
            return true;
          }
          if (_sloSchema.metricCustomBasicMetric.is(metric) && metric.field != null) {
            return true;
          }
          return false;
        });
        return isEquationValid && areMetricsValid;
      };
      isIndicatorSectionValid = ['indicator.params.index', 'indicator.params.filter', 'indicator.params.timestampField'].every(field => !getFieldState(field).invalid) && ['indicator.params.index', 'indicator.params.timestampField'].every(field => !!getValues(field)) && isGoodParamsValid() && isTotalParamsValid();
      break;
    case 'sli.metric.timeslice':
      const isMetricParamsValid = () => {
        var _data$metrics3;
        const data = getValues('indicator.params.metric');
        const isEquationValid = !getFieldState('indicator.params.metric.equation').invalid;
        const areMetricsValid = (0, _lodash.isObject)(data) && ((_data$metrics3 = data.metrics) !== null && _data$metrics3 !== void 0 ? _data$metrics3 : []).every(metric => {
          if (_sloSchema.timesliceMetricBasicMetricWithField.is(metric)) {
            return Boolean(metric.field);
          }
          if (_sloSchema.timesliceMetricPercentileMetric.is(metric)) {
            return Boolean(metric.field) && Boolean(metric.percentile);
          }
          return true;
        });
        return isEquationValid && areMetricsValid;
      };
      isIndicatorSectionValid = ['indicator.params.index', 'indicator.params.filter', 'indicator.params.timestampField'].every(field => !getFieldState(field).invalid) && ['indicator.params.index', 'indicator.params.timestampField'].every(field => !!getValues(field)) && isMetricParamsValid();
      break;
    case 'sli.histogram.custom':
      const isRangeValid = type => {
        const aggregation = getValues(`indicator.params.${type}.aggregation`);
        // If aggreagtion is a value count we can exit early with true
        if (aggregation === 'value_count') {
          return true;
        }
        const from = getValues(`indicator.params.${type}.from`);
        const to = getValues(`indicator.params.${type}.to`);
        // If both from and to are defined and from is less that to, return true
        if (from != null && to != null && from < to) {
          return true;
        }
        return false;
      };
      isIndicatorSectionValid = ['indicator.params.index', 'indicator.params.filter', 'indicator.params.timestampField', 'indicator.params.good.aggregation', 'indicator.params.total.aggregation', 'indicator.params.good.field', 'indicator.params.total.field', 'indicator.params.good.filter', 'indicator.params.total.filter'].every(field => !getFieldState(field).invalid) && ['indicator.params.good.aggregation', 'indicator.params.total.aggregation', 'indicator.params.good.field', 'indicator.params.total.field', 'indicator.params.index', 'indicator.params.timestampField'].every(field => !!getValues(field)) && isRangeValid('good') && isRangeValid('total');
      break;
    case 'sli.kql.custom':
      isIndicatorSectionValid = ['indicator.params.index', 'indicator.params.filter', 'indicator.params.total', 'indicator.params.timestampField'].every(field => !getFieldState(field).invalid) && ['indicator.params.good', 'indicator.params.index', 'indicator.params.timestampField'].every(field => !!getValues(field));
      break;
    case 'sli.apm.transactionDuration':
      isIndicatorSectionValid = ['indicator.params.service', 'indicator.params.environment', 'indicator.params.transactionType', 'indicator.params.transactionName', 'indicator.params.threshold'].every(field => !getFieldState(field, formState).invalid && getValues(field) !== '') && !getFieldState('indicator.params.index', formState).invalid;
      break;
    case 'sli.apm.transactionErrorRate':
      isIndicatorSectionValid = ['indicator.params.service', 'indicator.params.environment', 'indicator.params.transactionType', 'indicator.params.transactionName'].every(field => !getFieldState(field, formState).invalid && getValues(field) !== '') && ['indicator.params.index'].every(field => !getFieldState(field, formState).invalid);
      break;
    default:
      isIndicatorSectionValid = false;
      break;
  }
  const isObjectiveSectionValid = ['budgetingMethod', 'timeWindow.duration', 'objective.target', 'objective.timesliceTarget', 'objective.timesliceWindow'].every(field => getFieldState(field).error === undefined);
  const isDescriptionSectionValid = !getFieldState('name').invalid && getValues('name') !== '' && !getFieldState('description').invalid;
  return {
    isIndicatorSectionValid,
    isObjectiveSectionValid,
    isDescriptionSectionValid
  };
}