"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSelection = IndexSelection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_data_views = require("../../../../hooks/use_fetch_data_views");
var _use_fetch_indices = require("../../../../hooks/use_fetch_indices");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexSelection() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    isLoading: isIndicesLoading,
    data: indices = []
  } = (0, _use_fetch_indices.useFetchIndices)({
    search: searchValue
  });
  const {
    isLoading: isDataViewsLoading,
    data: dataViews = []
  } = (0, _use_fetch_data_views.useFetchDataViews)({
    name: searchValue
  });
  const options = [];
  if (!isDataViewsLoading && dataViews.length > 0) {
    options.push(createDataViewsOption(dataViews));
  }
  if (!isIndicesLoading && !!searchValue) {
    options.push(createIndexPatternOption(searchValue, indices));
  }
  const onSearchChange = (0, _lodash.debounce)(value => setSearchValue(value), 300);
  const placeholder = _i18n.i18n.translate('xpack.observability.slo.sloEdit.indexSelection.placeholder', {
    defaultMessage: 'Select an index pattern'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.label', {
      defaultMessage: 'Index'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.helpText', {
      defaultMessage: 'Use * to broaden your query.'
    }),
    isInvalid: getFieldState('indicator.params.index').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: "indicator.params.index",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      "aria-label": placeholder,
      async: true,
      "data-test-subj": "indexSelection",
      isClearable: true,
      isInvalid: fieldState.invalid,
      isLoading: isIndicesLoading && isDataViewsLoading,
      placeholder: placeholder,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      options: options,
      onSearchChange: onSearchChange,
      selectedOptions: !!field.value ? [{
        value: field.value,
        label: field.value,
        'data-test-subj': 'indexSelectionSelectedValue'
      }] : [],
      singleSelection: true
    }))
  }));
}
function createDataViewLabel(dataView) {
  return `${dataView.getName()} (${dataView.getIndexPattern()})`;
}
function createDataViewsOption(dataViews) {
  return {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.indexSelection.dataViewOptionsLabel', {
      defaultMessage: 'Select an index pattern from an existing Data View'
    }),
    options: dataViews.map(view => ({
      label: createDataViewLabel(view),
      value: view.getIndexPattern()
    })).sort((a, b) => String(a.label).localeCompare(b.label))
  };
}
function createIndexPatternOption(searchValue, indices) {
  const indexPattern = searchValue.endsWith('*') ? searchValue : `${searchValue}*`;
  const hasMatchingIndices = indices.length > 0;
  return {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.indexPatternLabel', {
      defaultMessage: 'Use the index pattern'
    }),
    options: [{
      value: indexPattern,
      label: hasMatchingIndices ? _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.indexPatternFoundLabel', {
        defaultMessage: '{searchPattern} (match {num, plural, one {# index} other {# indices}})',
        values: {
          searchPattern: indexPattern,
          num: indices.length
        }
      }) : _i18n.i18n.translate('xpack.observability.slo.sloEdit.indexSelection.indexPatternNoMatchLabel', {
        defaultMessage: '{searchPattern}',
        values: {
          searchPattern: indexPattern
        }
      })
    }]
  };
}