"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetails = SloDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_fetch_active_alerts = require("../../../hooks/slo/use_fetch_active_alerts");
var _use_fetch_historical_summary = require("../../../hooks/slo/use_fetch_historical_summary");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _burn_rates = require("./burn_rates");
var _error_budget_chart_panel = require("./error_budget_chart_panel");
var _events_chart_panel = require("./events_chart_panel");
var _overview = require("./overview/overview");
var _sli_chart_panel = require("./sli_chart_panel");
var _slo_detail_alerts = require("./slo_detail_alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_ID_URL_PARAM = 'tabId';
const OVERVIEW_TAB_ID = 'overview';
const ALERTS_TAB_ID = 'alerts';
const DAY_IN_MILLISECONDS = 24 * 60 * 60 * 1000;
function SloDetails({
  slo,
  isAutoRefreshing
}) {
  var _slo$instanceId, _slo$instanceId2, _ref, _tabs$find;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    data: activeAlerts
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: [[slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE]],
    shouldRefetch: isAutoRefreshing
  });
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    list: [{
      sloId: slo.id,
      instanceId: (_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : _sloSchema.ALL_VALUE
    }],
    shouldRefetch: isAutoRefreshing
  });
  const sloHistoricalSummary = historicalSummaries.find(historicalSummary => {
    var _slo$instanceId3;
    return historicalSummary.sloId === slo.id && historicalSummary.instanceId === ((_slo$instanceId3 = slo.instanceId) !== null && _slo$instanceId3 !== void 0 ? _slo$instanceId3 : _sloSchema.ALL_VALUE);
  });
  const [range, setRange] = (0, _react.useState)({
    start: new Date().getTime() - DAY_IN_MILLISECONDS,
    end: new Date().getTime()
  });
  (0, _react.useEffect)(() => {
    let intervalId;
    if (isAutoRefreshing) {
      intervalId = setInterval(() => {
        setRange({
          start: new Date().getTime() - DAY_IN_MILLISECONDS,
          end: new Date().getTime()
        });
      }, 60 * 1000);
    }
    return () => clearInterval(intervalId);
  }, [isAutoRefreshing]);
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'error_budget_remaining');
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'sli_value');
  const tabs = [{
    id: OVERVIEW_TAB_ID,
    name: _i18n.i18n.translate('xpack.observability.slo.sloDetails.tab.overviewLabel', {
      defaultMessage: 'Overview'
    }),
    'data-test-subj': 'overviewTab',
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview.Overview, {
      slo: slo
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_burn_rates.BurnRates, {
      slo: slo,
      isAutoRefreshing: isAutoRefreshing
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sli_chart_panel.SliChartPanel, {
      data: historicalSliData,
      isLoading: historicalSummaryLoading,
      slo: slo
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_error_budget_chart_panel.ErrorBudgetChartPanel, {
      data: errorBudgetBurnDownData,
      isLoading: historicalSummaryLoading,
      slo: slo
    })), slo.indicator.type !== 'sli.metric.timeslice' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_events_chart_panel.EventsChartPanel, {
      slo: slo,
      range: range
    })) : null)))
  }, {
    id: ALERTS_TAB_ID,
    name: _i18n.i18n.translate('xpack.observability.slo.sloDetails.tab.alertsLabel', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'alertsTab',
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m"
    }, (_ref = activeAlerts && activeAlerts.get(slo)) !== null && _ref !== void 0 ? _ref : 0),
    content: /*#__PURE__*/_react.default.createElement(_slo_detail_alerts.SloDetailsAlerts, {
      slo: slo
    })
  }];
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(() => {
    const searchParams = new URLSearchParams(search);
    const urlTabId = searchParams.get(TAB_ID_URL_PARAM);
    return urlTabId && [OVERVIEW_TAB_ID, ALERTS_TAB_ID].includes(urlTabId) ? urlTabId : OVERVIEW_TAB_ID;
  });
  const handleSelectedTab = newTabId => {
    setSelectedTabId(newTabId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "sloDetailsTabbedContent",
    tabs: tabs,
    selectedTab: (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0],
    onTabClick: tab => handleSelectedTab(tab.id)
  });
}