"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderActions({
  isLoading,
  isRuleEditable,
  onDeleteRule,
  onEditRule
}) {
  const [isRuleEditPopoverOpen, setIsRuleEditPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = () => setIsRuleEditPopoverOpen(!isRuleEditPopoverOpen);
  const handleEditRule = () => {
    setIsRuleEditPopoverOpen(false);
    onEditRule();
  };
  const handleRemoveRule = () => {
    setIsRuleEditPopoverOpen(false);
    onDeleteRule();
  };
  return isRuleEditable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "rowReverse",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextRuleEditMenu",
    isOpen: isRuleEditPopoverOpen,
    closePopover: togglePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "actions",
      disabled: isLoading,
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: togglePopover
    }, _i18n.i18n.translate('xpack.observability.ruleDetails.actionsButtonLabel', {
      defaultMessage: 'Actions'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "editRuleButton",
    size: "s",
    iconType: "pencil",
    onClick: handleEditRule
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.ruleDetails.editRule', {
    defaultMessage: 'Edit rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "trash",
    color: "danger",
    onClick: handleRemoveRule,
    "data-test-subj": "deleteRuleButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.ruleDetails.deleteRule', {
    defaultMessage: 'Delete rule'
  }))))))) : null;
}