"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmationModal = DeleteConfirmationModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_delete_rules = require("../../../hooks/use_delete_rules");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DeleteConfirmationModal({
  ruleIdToDelete,
  title,
  onCancel,
  onDeleted,
  onDeleting
}) {
  const [isVisible, setIsVisible] = (0, _react.useState)(Boolean(ruleIdToDelete));
  const {
    mutateAsync: deleteRules
  } = (0, _use_delete_rules.useDeleteRules)();
  const handleConfirm = async () => {
    if (ruleIdToDelete) {
      setIsVisible(false);
      onDeleting();
      await deleteRules({
        ids: [ruleIdToDelete]
      });
      onDeleted();
    }
  };
  return isVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "deleteIdsConfirmation",
    title: _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.descriptionText', {
      defaultMessage: "You can't recover {title} after deleting.",
      values: {
        title
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.deleteButtonLabel', {
      defaultMessage: 'Delete {title}',
      values: {
        title
      }
    }),
    onCancel: onCancel,
    onConfirm: handleConfirm
  }, _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.descriptionText', {
    defaultMessage: "You can't recover {title} after deleting.",
    values: {
      title
    }
  })) : null;
}