"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebCoreVitalsTitle = WebCoreVitalsTitle;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CORE_WEB_VITALS = _i18n.i18n.translate('xpack.observability.ux.coreWebVitals', {
  defaultMessage: 'Core web vitals'
});
const BROWSER_CORE_WEB_VITALS = _i18n.i18n.translate('xpack.observability.ux.coreWebVitals.browser.support', {
  defaultMessage: 'browser support for core web vitals'
});
function WebCoreVitalsTitle({
  loading,
  coreVitalPages,
  totalPageViews = 0,
  displayTrafficMetric
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isBrowserPopoverOpen, setIsBrowserPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const closeBrowserPopover = () => setIsBrowserPopoverOpen(false);
  const helpAriaLabel = _i18n.i18n.translate('xpack.observability.ux.dashboard.webCoreVitals.helpAriaLabel', {
    defaultMessage: 'help'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, CORE_WEB_VITALS, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "o11yWebCoreVitalsTitleButton",
      "aria-label": helpAriaLabel,
      onClick: () => setIsPopoverOpen(true),
      color: 'text',
      iconType: 'questionInCircle'
    }),
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.ux.dashboard.webCoreVitals.help",
    defaultMessage: "Learn more about"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11yWebCoreVitalsTitleLink",
    href: "https://web.dev/vitals/",
    external: true,
    target: "_blank"
  }, CORE_WEB_VITALS))))))), displayTrafficMetric && totalPageViews > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.ux.dashboard.webCoreVitals.traffic",
    defaultMessage: "{trafficPerc} of the traffic represented",
    values: {
      trafficPerc: /*#__PURE__*/_react.default.createElement("strong", null, " ", ((coreVitalPages || 0) / totalPageViews * 100).toFixed(0), "%")
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isBrowserPopoverOpen,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "o11yWebCoreVitalsTitleButton",
      "aria-label": helpAriaLabel,
      onClick: () => setIsBrowserPopoverOpen(true),
      color: 'text',
      iconType: 'questionInCircle'
    }),
    closePopover: closeBrowserPopover
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.ux.dashboard.webCoreVitals.browser.help",
    defaultMessage: "Learn more about"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11yWebCoreVitalsTitleLink",
    href: "https://github.com/GoogleChrome/web-vitals#browser-support",
    external: true,
    target: "_blank"
  }, BROWSER_CORE_WEB_VITALS)))))));
}