"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSections = DataSections;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _apm_section = require("./sections/apm/apm_section");
var _logs_section = require("./sections/logs/logs_section");
var _metrics_section = require("./sections/metrics/metrics_section");
var _uptime_section = require("./sections/uptime/uptime_section");
var _ux_section = require("./sections/ux/ux_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataSections({
  bucketSize
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_logs_section.LogsSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metrics_section.MetricsSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_apm_section.APMSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_uptime_section.UptimeSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ux_section.UXSection, {
    bucketSize: bucketSize
  }))));
}