"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloConfiguration = SloConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _slo_selector = require("./slo_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloConfiguration({
  initialInput,
  onCreate,
  onCancel
}) {
  var _initialInput$slos;
  const [selectedSlos, setSelectedSlos] = (0, _react.useState)((_initialInput$slos = initialInput === null || initialInput === void 0 ? void 0 : initialInput.slos) !== null && _initialInput$slos !== void 0 ? _initialInput$slos : []);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const onConfirmClick = () => onCreate({
    slos: selectedSlos
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCancel,
    css: `
        min-width: 550px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.observability.sloEmbeddable.config.sloSelector.headerTitle', {
    defaultMessage: 'SLO configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    initialSlos: selectedSlos,
    hasError: hasError,
    singleSelection: false,
    onSelected: slos => {
      setHasError(slos === undefined);
      if (Array.isArray(slos)) {
        setSelectedSlos(slos === null || slos === void 0 ? void 0 : slos.map(slo => ({
          id: slo === null || slo === void 0 ? void 0 : slo.id,
          instanceId: slo === null || slo === void 0 ? void 0 : slo.instanceId,
          name: slo === null || slo === void 0 ? void 0 : slo.name,
          groupBy: slo === null || slo === void 0 ? void 0 : slo.groupBy
        })));
      }
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.sloEmbeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    isDisabled: !selectedSlos || selectedSlos.length === 0 || hasError,
    onClick: onConfirmClick,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.embeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Confirm configurations"
  }))));
}