"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloActiveAlertsBadge = SloActiveAlertsBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _paths = require("../../../../common/locators/paths");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloActiveAlertsBadge({
  slo,
  activeAlerts,
  viewMode = 'default'
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const handleActiveAlertsClick = () => {
    if (activeAlerts) {
      const kuery = encodeURIComponent(`'slo.id:"${slo.id}" and slo.instanceId:"${slo.instanceId}"'`);
      navigateToUrl(`${basePath.prepend(_paths.paths.observability.alerts)}?_a=(kuery:${kuery},rangeFrom:now-15m,rangeTo:now,status:active)`);
    }
  };
  if (!activeAlerts) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "danger",
    onClick: handleActiveAlertsClick,
    onClickAriaLabel: _i18n.i18n.translate('xpack.observability.slo.slo.activeAlertsBadge.ariaLabel', {
      defaultMessage: 'active alerts badge'
    }),
    "data-test-subj": "o11ySloActiveAlertsBadge"
  }, viewMode !== 'default' ? activeAlerts : _i18n.i18n.translate('xpack.observability.slo.slo.activeAlertsBadge.label', {
    defaultMessage: '{count, plural, one {# alert} other {# alerts}}',
    values: {
      count: activeAlerts
    }
  })));
}