"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregationType = exports.ExpressionRow = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _lodash = require("lodash");
var _types = require("../../../../common/custom_threshold_rule/types");
var _custom_equation = require("./custom_equation");
var _i18n_strings = require("../i18n_strings");
var _corrected_percent_convert = require("../helpers/corrected_percent_convert");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Create a new object with COMPARATORS.NOT_BETWEEN removed as we use OUTSIDE_RANGE
const updatedBuiltInComparators = {
  ..._public.builtInComparators
};
delete updatedBuiltInComparators[_public.COMPARATORS.NOT_BETWEEN];
const customComparators = {
  ...updatedBuiltInComparators,
  [_types.Comparator.OUTSIDE_RANGE]: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.outsideRangeLabel', {
      defaultMessage: 'Is not between'
    }),
    value: _types.Comparator.OUTSIDE_RANGE,
    requiredValues: 2
  }
};
const StyledExpressionRow = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  margin: 0 -4px;
`;

// eslint-disable-next-line react/function-component-definition
const ExpressionRow = props => {
  var _ref;
  const {
    dataView,
    children,
    setRuleParams,
    expression,
    errors,
    expressionId,
    remove,
    fields,
    canDelete,
    title
  } = props;
  const {
    metrics,
    comparator = _types.Comparator.GT,
    threshold = []
  } = expression;
  const isMetricPct = (0, _react.useMemo)(() => {
    var _metrics$0$field;
    return Boolean(metrics.length === 1 && ((_metrics$0$field = metrics[0].field) === null || _metrics$0$field === void 0 ? void 0 : _metrics$0$field.endsWith('.pct')));
  }, [metrics]);
  const [label, setLabel] = (0, _react.useState)((expression === null || expression === void 0 ? void 0 : expression.label) || undefined);
  const updateComparator = (0, _react.useCallback)(c => {
    setRuleParams(expressionId, {
      ...expression,
      comparator: c
    });
  }, [expressionId, expression, setRuleParams]);
  const convertThreshold = (0, _react.useCallback)(enteredThreshold => isMetricPct ? enteredThreshold.map(v => (0, _corrected_percent_convert.pctToDecimal)(v)) : enteredThreshold, [isMetricPct]);
  const updateThreshold = (0, _react.useCallback)(enteredThreshold => {
    const t = convertThreshold(enteredThreshold);
    if (t.join() !== expression.threshold.join()) {
      setRuleParams(expressionId, {
        ...expression,
        threshold: t
      });
    }
  }, [expressionId, expression, convertThreshold, setRuleParams]);
  const handleCustomMetricChange = (0, _react.useCallback)(exp => {
    setRuleParams(expressionId, exp);
  }, [expressionId, setRuleParams]);
  const debouncedLabelChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(handleCustomMetricChange, 300), [handleCustomMetricChange]);
  const criticalThresholdExpression = /*#__PURE__*/_react.default.createElement(ThresholdElement, {
    comparator: comparator,
    threshold: threshold,
    updateComparator: updateComparator,
    updateThreshold: updateThreshold,
    errors: (_ref = errors.critical) !== null && _ref !== void 0 ? _ref : {},
    isMetricPct: isMetricPct
  });
  const normalizedFields = fields.map(f => ({
    normalizedType: f.type,
    name: f.name
  }));
  const handleLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
    debouncedLabelChange({
      ...expression,
      label: e.target.value
    });
  }, [debouncedLabelChange, expression]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, title))), canDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yExpressionRowButton",
    "aria-label": _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.removeCondition', {
      defaultMessage: 'Remove condition'
    }),
    color: 'text',
    iconType: 'trash',
    onClick: () => remove(expressionId)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(StyledExpressionRow, {
    style: {
      gap: 24
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  }), /*#__PURE__*/_react.default.createElement(_custom_equation.CustomEquationEditor, {
    expression: expression,
    fields: normalizedFields,
    aggregationTypes: aggregationType,
    onChange: handleCustomMetricChange,
    errors: errors,
    dataView: dataView
  }), criticalThresholdExpression, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_strings.LABEL_LABEL,
    fullWidth: true,
    helpText: _i18n_strings.LABEL_HELP_MESSAGE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "thresholdRuleCustomEquationEditorFieldText",
    compressed: true,
    fullWidth: true,
    value: label,
    placeholder: _i18n_strings.CUSTOM_EQUATION,
    onChange: handleLabelChange
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), children);
};
exports.ExpressionRow = ExpressionRow;
const ThresholdElement = ({
  updateComparator,
  updateThreshold,
  threshold,
  isMetricPct,
  comparator,
  errors
}) => {
  const displayedThreshold = (0, _react.useMemo)(() => {
    if (isMetricPct) return threshold.map(v => (0, _corrected_percent_convert.decimalToPct)(v));
    return threshold;
  }, [threshold, isMetricPct]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ThresholdExpression, {
    thresholdComparator: comparator || _types.Comparator.GT,
    threshold: displayedThreshold,
    customComparators: customComparators,
    onChangeSelectedThresholdComparator: updateComparator,
    onChangeSelectedThreshold: updateThreshold,
    errors: errors,
    display: "fullWidth",
    unit: isMetricPct ? '%' : ''
  }));
};
const aggregationType = {
  avg: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.avg', {
      defaultMessage: 'Average'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'histogram'],
    value: _types.Aggregators.AVERAGE
  },
  max: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.max', {
      defaultMessage: 'Max'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'date', 'histogram'],
    value: _types.Aggregators.MAX
  },
  min: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.min', {
      defaultMessage: 'Min'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'date', 'histogram'],
    value: _types.Aggregators.MIN
  },
  cardinality: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.cardinality', {
      defaultMessage: 'Cardinality'
    }),
    fieldRequired: false,
    value: _types.Aggregators.CARDINALITY,
    validNormalizedTypes: ['number', 'string', 'ip', 'date']
  },
  count: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.count', {
      defaultMessage: 'Count'
    }),
    fieldRequired: false,
    value: _types.Aggregators.COUNT,
    validNormalizedTypes: ['number']
  },
  sum: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.sum', {
      defaultMessage: 'Sum'
    }),
    fieldRequired: false,
    value: _types.Aggregators.SUM,
    validNormalizedTypes: ['number', 'histogram']
  }
};
exports.aggregationType = aggregationType;