"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AlertDetailsAppSection;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _types = require("../../../../common/custom_threshold_rule/types");
var _kibana_react = require("../../../utils/kibana_react");
var _metric_value_formatter = require("../../../../common/custom_threshold_rule/metric_value_formatter");
var _expression_chart = require("./expression_chart");
var _criterion_preview_chart = require("./criterion_preview_chart/criterion_preview_chart");
var _custom_threshold = require("./custom_threshold");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Use a generic props for app sections https://github.com/elastic/kibana/issues/152690

const DEFAULT_DATE_FORMAT = 'YYYY-MM-DD HH:mm';
const ALERT_START_ANNOTATION_ID = 'alert_start_annotation';
const ALERT_TIME_RANGE_ANNOTATION_ID = 'alert_time_range_annotation';
// eslint-disable-next-line import/no-default-export
function AlertDetailsAppSection({
  alert,
  rule,
  ruleLink,
  setAlertSummaryFields
}) {
  const {
    uiSettings,
    charts,
    data
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [dataView, setDataView] = (0, _react.useState)();
  const [, setDataViewError] = (0, _react.useState)();
  const ruleParams = rule.params;
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  const annotations = [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertAnnotation, {
    alertStart: alert.start,
    color: euiTheme.colors.danger,
    dateFormat: uiSettings.get('dateFormat') || DEFAULT_DATE_FORMAT,
    id: ALERT_START_ANNOTATION_ID,
    key: ALERT_START_ANNOTATION_ID
  }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertActiveTimeRangeAnnotation, {
    alertStart: alert.start,
    alertEnd: alertEnd,
    color: euiTheme.colors.danger,
    id: ALERT_TIME_RANGE_ANNOTATION_ID,
    key: ALERT_TIME_RANGE_ANNOTATION_ID
  })];
  (0, _react.useEffect)(() => {
    setAlertSummaryFields([{
      label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.summaryField.rule', {
        defaultMessage: 'Rule'
      }),
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "thresholdRuleAlertDetailsAppSectionRuleLink",
        href: ruleLink
      }, rule.name)
    }]);
  }, [alert, rule, ruleLink, setAlertSummaryFields]);
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: (dataView === null || dataView === void 0 ? void 0 : dataView.fields) || [],
    title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || 'unknown-index'
  }), [dataView]);
  (0, _react.useEffect)(() => {
    const initDataView = async () => {
      const ruleSearchConfiguration = ruleParams.searchConfiguration;
      try {
        const createdSearchSource = await data.search.searchSource.create(ruleSearchConfiguration);
        setDataView(createdSearchSource.getField('index'));
      } catch (error) {
        setDataViewError(error);
      }
    };
    initDataView();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource]);
  const overview = !!ruleParams.criteria ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "thresholdAlertOverviewSection"
  }, ruleParams.criteria.map((criterion, index) => {
    var _ruleParams$searchCon, _ruleParams$searchCon2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `criterion-${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, criterion.label || 'CUSTOM', " ")), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.customThreshold.rule.alertDetailsAppSection.criterion.subtitle",
      defaultMessage: "Last {lookback} {timeLabel}",
      values: {
        lookback: criterion.timeSize,
        timeLabel: _criterion_preview_chart.TIME_LABELS[criterion.timeUnit]
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minHeight: 150,
        minWidth: 160
      },
      grow: 1
    }, /*#__PURE__*/_react.default.createElement(_custom_threshold.Threshold, {
      chartProps: chartProps,
      id: `threshold-${index}`,
      threshold: criterion.threshold,
      value: alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUES][index],
      valueFormatter: d => (0, _metric_value_formatter.metricValueFormatter)(d, criterion.metrics[0] ? criterion.metrics[0].name : undefined),
      title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.thresholdTitle', {
        defaultMessage: 'Threshold breached'
      }),
      comparator: criterion.comparator
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 5
    }, /*#__PURE__*/_react.default.createElement(_expression_chart.ExpressionChart, {
      annotations: annotations,
      chartType: _types.MetricsExplorerChartType.line,
      derivedIndexPattern: derivedIndexPattern,
      expression: criterion,
      filterQuery: (_ruleParams$searchCon = ruleParams.searchConfiguration) === null || _ruleParams$searchCon === void 0 ? void 0 : (_ruleParams$searchCon2 = _ruleParams$searchCon.query) === null || _ruleParams$searchCon2 === void 0 ? void 0 : _ruleParams$searchCon2.query,
      groupBy: ruleParams.groupBy,
      hideTitle: true,
      timeRange: timeRange
    })))));
  })) : null;
  return overview;
}
module.exports = exports.default;