"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRateRuleEditor = BurnRateRuleEditor;
var _react = _interopRequireWildcard(require("react"));
var _sloSchema = require("@kbn/slo-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_fetch_slo_details = require("../../hooks/slo/use_fetch_slo_details");
var _slo_selector = require("./slo_selector");
var _windows = require("./windows");
var _constants = require("../../../common/constants");
var _constants2 = require("./constants");
var _alert_time_table = require("./alert_time_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BurnRateRuleEditor(props) {
  const {
    setRuleParams,
    ruleParams,
    errors
  } = props;
  const {
    isLoading: loadingInitialSlo,
    data: initialSlo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId: ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.sloId
  });
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const hasInitialSlo = !loadingInitialSlo && initialSlo !== undefined;
    setSelectedSlo(hasInitialSlo ? initialSlo : undefined);
  }, [loadingInitialSlo, initialSlo, setRuleParams]);
  const onSelectedSlo = slo => {
    setSelectedSlo(slo);
    setRuleParams('sloId', slo === null || slo === void 0 ? void 0 : slo.id);
  };
  const [windowDefs, setWindowDefs] = (0, _react.useState)((ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.windows) || [(0, _windows.createNewWindow)(selectedSlo, {
    burnRateThreshold: 14.4,
    longWindow: {
      value: 1,
      unit: 'h'
    },
    shortWindow: {
      value: 5,
      unit: 'm'
    },
    actionGroup: _constants.ALERT_ACTION.id
  }), (0, _windows.createNewWindow)(selectedSlo, {
    burnRateThreshold: 6,
    longWindow: {
      value: 6,
      unit: 'h'
    },
    shortWindow: {
      value: 30,
      unit: 'm'
    },
    actionGroup: _constants.HIGH_PRIORITY_ACTION.id
  }), (0, _windows.createNewWindow)(selectedSlo, {
    burnRateThreshold: 3,
    longWindow: {
      value: 24,
      unit: 'h'
    },
    shortWindow: {
      value: 120,
      unit: 'm'
    },
    actionGroup: _constants.MEDIUM_PRIORITY_ACTION.id
  }), (0, _windows.createNewWindow)(selectedSlo, {
    burnRateThreshold: 1,
    longWindow: {
      value: 72,
      unit: 'h'
    },
    shortWindow: {
      value: 360,
      unit: 'm'
    },
    actionGroup: _constants.LOW_PRIORITY_ACTION.id
  })]);

  // When the SLO changes, recalculate the max burn rates
  (0, _react.useEffect)(() => {
    setWindowDefs(() => {
      const burnRateDefaults = selectedSlo ? _constants2.BURN_RATE_DEFAULTS[selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.timeWindow.duration] : _constants2.BURN_RATE_DEFAULTS['30d'];
      return burnRateDefaults.map(partialWindow => (0, _windows.createNewWindow)(selectedSlo, partialWindow));
    });
  }, [selectedSlo]);
  (0, _react.useEffect)(() => {
    setRuleParams('windows', windowDefs);
  }, [windowDefs, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.observability.burnRateRuleEditor.h5.chooseASLOToMonitorLabel', {
    defaultMessage: 'Choose a SLO to monitor'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    initialSlo: selectedSlo,
    onSelected: onSelectedSlo,
    errors: errors.sloId
  }), (selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.groupBy) && selectedSlo.groupBy !== _sloSchema.ALL_VALUE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    title: _i18n.i18n.translate('xpack.observability.slo.rules.groupByMessage', {
      defaultMessage: 'The SLO you selected has been created with a group-by on "{groupByField}". This rule will monitor and generate an alert for every instance found in the group-by field.',
      values: {
        groupByField: selectedSlo.groupBy
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), selectedSlo && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_windows.Windows, {
    slo: selectedSlo,
    windows: windowDefs,
    onChange: setWindowDefs,
    errors: errors.windows
  }), /*#__PURE__*/_react.default.createElement(_alert_time_table.AlertTimeTable, {
    slo: selectedSlo,
    windows: windowDefs
  })));
}