"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNTRACKED_ALERTS = exports.RECOVERED_ALERTS = exports.DEFAULT_QUERY_STRING = exports.DEFAULT_QUERIES = exports.ALL_ALERTS = exports.ALERT_STATUS_QUERY = exports.ACTIVE_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERIES = [];
exports.DEFAULT_QUERIES = DEFAULT_QUERIES;
const DEFAULT_QUERY_STRING = '';
exports.DEFAULT_QUERY_STRING = DEFAULT_QUERY_STRING;
const ALL_ALERTS = {
  status: _constants.ALERT_STATUS_ALL,
  query: '',
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.showAll', {
    defaultMessage: 'Show all'
  })
};
exports.ALL_ALERTS = ALL_ALERTS;
const ACTIVE_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_ACTIVE,
  query: `${_ruleDataUtils.ALERT_STATUS}: "${_ruleDataUtils.ALERT_STATUS_ACTIVE}"`,
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.active', {
    defaultMessage: 'Active'
  })
};
exports.ACTIVE_ALERTS = ACTIVE_ALERTS;
const RECOVERED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_RECOVERED,
  query: `${_ruleDataUtils.ALERT_STATUS}: "${_ruleDataUtils.ALERT_STATUS_RECOVERED}"`,
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.recovered', {
    defaultMessage: 'Recovered'
  })
};
exports.RECOVERED_ALERTS = RECOVERED_ALERTS;
const UNTRACKED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_UNTRACKED,
  query: `${_ruleDataUtils.ALERT_STATUS}: "${_ruleDataUtils.ALERT_STATUS_UNTRACKED}"`,
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.untracked', {
    defaultMessage: 'Untracked'
  })
};
exports.UNTRACKED_ALERTS = UNTRACKED_ALERTS;
const ALERT_STATUS_QUERY = {
  [ACTIVE_ALERTS.status]: ACTIVE_ALERTS.query,
  [RECOVERED_ALERTS.status]: RECOVERED_ALERTS.query,
  [UNTRACKED_ALERTS.status]: UNTRACKED_ALERTS.query
};
exports.ALERT_STATUS_QUERY = ALERT_STATUS_QUERY;