"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAlertSearchbarWithUrlSync = ObservabilityAlertSearchbarWithUrlSync;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _containers = require("./containers");
var _alert_search_bar = require("./alert_search_bar");
var _kibana_react = require("../../utils/kibana_react");
var _use_toast = require("../../hooks/use_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertSearchbarWithUrlSync(props) {
  const {
    urlStorageKey,
    ...searchBarProps
  } = props;
  const stateProps = (0, _containers.useAlertSearchBarStateContainer)(urlStorageKey);
  const {
    data: {
      query: {
        timefilter: {
          timefilter: timeFilterService
        }
      }
    },
    triggersActionsUi: {
      getAlertsSearchBar: AlertsSearchBar
    }
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_alert_search_bar.ObservabilityAlertSearchBar, (0, _extends2.default)({}, stateProps, searchBarProps, {
    services: {
      timeFilterService,
      AlertsSearchBar,
      useToasts: _use_toast.useToasts
    }
  }));
}
function ObservabilityAlertSearchbarWithUrlSync(props) {
  return /*#__PURE__*/_react.default.createElement(_containers.Provider, {
    value: _containers.alertSearchBarStateContainer
  }, /*#__PURE__*/_react.default.createElement(AlertSearchbarWithUrlSync, props));
}