"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityOnboardingFlow = exports.OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE = 'observability-onboarding-state';
exports.OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE = OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE;
const LogFilesStateSchema = _configSchema.schema.object({
  datasetName: _configSchema.schema.string(),
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  customConfigurations: _configSchema.schema.maybe(_configSchema.schema.string()),
  logFilePaths: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  namespace: _configSchema.schema.string()
});
const SystemLogsStateSchema = _configSchema.schema.object({
  namespace: _configSchema.schema.string()
});
const ElasticAgentStepPayloadSchema = _configSchema.schema.object({
  agentId: _configSchema.schema.string()
});
const observabilityOnboardingFlow = {
  name: OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE,
  hidden: false,
  namespaceType: 'agnostic',
  mappings: {
    properties: {
      type: {
        type: 'keyword'
      },
      state: {
        type: 'object',
        dynamic: false
      },
      progress: {
        type: 'object',
        dynamic: false
      }
    }
  },
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        create: _configSchema.schema.object({
          type: _configSchema.schema.string(),
          state: _configSchema.schema.maybe(_configSchema.schema.oneOf([LogFilesStateSchema, SystemLogsStateSchema])),
          progress: _configSchema.schema.mapOf(_configSchema.schema.string(), _configSchema.schema.object({
            status: _configSchema.schema.string(),
            message: _configSchema.schema.maybe(_configSchema.schema.string()),
            payload: _configSchema.schema.maybe(ElasticAgentStepPayloadSchema)
          }))
        })
      }
    }
  }
};
exports.observabilityOnboardingFlow = observabilityOnboardingFlow;