"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilmstripFrame = FilmstripFrame;
exports.FilmstripTransition = FilmstripTransition;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FilmstripTransition({
  children,
  duration,
  transition
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      flexFlow: 'column nowrap',
      flexGrow: 1,
      position: 'relative',
      zIndex: 0,
      transitionTimingFunction: 'ease-in-out',
      transition: transition !== 'ready' ? `transform ${duration}ms` : undefined,
      transform: transition === 'ready' ? 'translateX(0)' : transition === 'back' ? 'translateX(200%)' : 'translateX(-200%)'
    }
  }, children);
}
function FilmstripFrame({
  children,
  position
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup
  // alignItems="center"
  // justifyContent="spaceAround"
  , {
    alignItems: "flexStart",
    style: position !== 'center' ? {
      position: 'absolute',
      width: '100%',
      height: '100%',
      transform: position === 'left' ? 'translateX(-200%)' : 'translateX(200%)',
      pointerEvents: 'none'
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children));
}