"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Home = Home;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _app = require("../../../application/app");
var _use_kibana_navigation = require("../../../hooks/use_kibana_navigation");
var _apache = _interopRequireDefault(require("../../../icons/apache.svg"));
var _apm = _interopRequireDefault(require("../../../icons/apm.svg"));
var _aws = _interopRequireDefault(require("../../../icons/aws.svg"));
var _azure = _interopRequireDefault(require("../../../icons/azure.svg"));
var _gcp = _interopRequireDefault(require("../../../icons/gcp.svg"));
var _kinesis = _interopRequireDefault(require("../../../icons/kinesis.svg"));
var _kubernetes = _interopRequireDefault(require("../../../icons/kubernetes.svg"));
var _logging = _interopRequireDefault(require("../../../icons/logging.svg"));
var _nginx = _interopRequireDefault(require("../../../icons/nginx.svg"));
var _opentelemetry = _interopRequireDefault(require("../../../icons/opentelemetry.svg"));
var _system = _interopRequireDefault(require("../../../icons/system.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledItem = (0, _styled.default)(_eui.EuiFlexItem)`
  flex-direction: row;
  &:before {
    content: '•';
    margin-right: 20px;
  }
`;
function Home() {
  (0, _public.useBreadcrumbs)([], _app.breadcrumbsApp);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    navigateToKibanaUrl
  } = (0, _use_kibana_navigation.useKibanaNavigation)();
  const handleClickSystemLogs = () => {
    navigateToKibanaUrl('/app/observabilityOnboarding/systemLogs');
  };
  const handleClickCustomLogs = () => {
    navigateToKibanaUrl('/app/observabilityOnboarding/customLogs');
  };
  const handleClickApmSetupGuide = () => {
    navigateToKibanaUrl('/app/apm/tutorial');
  };
  const handleClickKubernetesSetupGuide = () => {
    navigateToKibanaUrl('/app/integrations/detail/kubernetes');
  };
  const handleClickIntegrations = () => {
    navigateToKibanaUrl('/app/integrations');
  };
  const handleClickSampleData = () => {
    navigateToKibanaUrl('/app/home#/tutorial_directory/sampleData');
  };
  const handleClickUploadFile = () => {
    navigateToKibanaUrl('/app/home#/tutorial_directory/fileDataViz');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    style: {
      margin: 'auto',
      maxWidth: 800
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "obltOnboardingHomeTitle"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.observability_onboarding.home.title', {
    defaultMessage: 'Collect and analyze logs'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.home.description', {
    defaultMessage: 'Select your method for collecting data into Observability.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _system.default,
      size: "l"
    }),
    betaBadgeProps: {
      'data-test-subj': 'obltOnboardingHomeQuickstartBadge',
      color: 'accent',
      label: _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.quickstartBadge', {
        defaultMessage: 'Quick start'
      })
    },
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.title', {
      defaultMessage: 'Stream host system logs'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: handleClickSystemLogs,
      color: "primary",
      fill: true,
      "data-test-subj": "obltOnboardingHomeStartSystemLogStream"
    }, getStartedLabel),
    style: {
      borderColor: euiTheme.colors.accent,
      borderWidth: 2
    },
    paddingSize: "m",
    display: "plain",
    hasBorder: true,
    onClick: handleClickSystemLogs
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, elasticAgentLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.description1', {
    defaultMessage: 'The quickest path to onboard log data from your own machine or server.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _logging.default,
      size: "l"
    }),
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.title', {
      defaultMessage: 'Stream log files'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: handleClickCustomLogs,
      color: "primary",
      fill: true,
      "data-test-subj": "obltOnboardingHomeStartLogFileStream"
    }, getStartedLabel),
    paddingSize: "m",
    display: "plain",
    hasBorder: true,
    onClick: handleClickCustomLogs
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, elasticAgentLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.description.text', {
    defaultMessage: 'Stream any logs into Elastic in a simple way and explore their data.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _apm.default,
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _opentelemetry.default,
      size: "l"
    })),
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.apm.title', {
      defaultMessage: 'Collect application performance data'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.apm.description', {
      defaultMessage: 'Collect traces, logs, and metrics from OpenTelemetry or APM custom agent.'
    }))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: handleClickApmSetupGuide,
      color: "primary",
      "data-test-subj": "obltOnboardingHomeStartApmTutorial"
    }, getStartedLabel),
    paddingSize: "m",
    titleSize: "xs",
    display: "plain",
    hasBorder: true,
    onClick: handleClickApmSetupGuide
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _kubernetes.default,
      size: "l"
    }),
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.k8s.title', {
      defaultMessage: 'Collect Kubernetes clusters data'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.k8s.description', {
      defaultMessage: 'Collect logs and metrics from Kubernetes clusters with Elastic Agent.'
    }))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: handleClickKubernetesSetupGuide,
      color: "primary",
      "data-test-subj": "obltOnboardingHomeGoToKubernetesIntegration"
    }, getStartedLabel),
    titleSize: "xs",
    paddingSize: "m",
    display: "plain",
    hasBorder: true,
    onClick: handleClickKubernetesSetupGuide
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _kinesis.default,
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _aws.default,
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _apache.default,
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _nginx.default,
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _gcp.default,
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _azure.default,
      size: "l"
    })),
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.title', {
      defaultMessage: 'Explore 300+ ways of ingesting data with our integrations'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: handleClickIntegrations,
      color: "primary",
      "data-test-subj": "obltOnboardingHomeExploreIntegrations"
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.start', {
      defaultMessage: 'Start exploring'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.quickLinks', {
      defaultMessage: 'Quick links:'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        flexWrap: 'nowrap'
      },
      alignItems: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: handleClickSampleData,
      "data-test-subj": "obltOnboardingHomeUseSampleData"
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.sampleData', {
      defaultMessage: 'Use sample data'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(StyledItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: handleClickUploadFile,
      "data-test-subj": "obltOnboardingHomeUploadAFile"
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.uploadFile', {
      defaultMessage: 'Upload a file'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(StyledItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "observabilityOnboardingHomeAwsFirehoseLink",
      href: "https://www.elastic.co/guide/en/kinesis/current/aws-firehose-setup-guide.html",
      target: "_blank",
      external: true,
      style: {
        whiteSpace: 'nowrap'
      }
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.awsFirehose', {
      defaultMessage: 'AWS Firehose'
    }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })),
    titleSize: "xs",
    paddingSize: "m",
    display: "plain",
    hasBorder: true
  }))));
}
const getStartedLabel = _i18n.i18n.translate('xpack.observability_onboarding.card.getStarted', {
  defaultMessage: 'Get started'
});
const elasticAgentLabel = _i18n.i18n.translate('xpack.observability_onboarding.card.elasticAgent', {
  defaultMessage: 'Elastic Agent'
});