"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OriginInterpreter = void 0;
var _xstateUtils = require("@kbn/xstate-utils");
var _react = require("@xstate/react");
var _state_machine = require("./state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OriginInterpreter = ({
  history,
  toasts
}) => {
  (0, _react.useInterpret)(() => (0, _state_machine.createOriginInterpreterStateMachine)({
    history,
    toasts
  }), {
    devTools: (0, _xstateUtils.isDevMode)()
  });
  return null;
};
exports.OriginInterpreter = OriginInterpreter;