"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderObservabilityLogExplorer = exports.ObservabilityLogExplorerApp = void 0;
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _main = require("../routes/main");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderObservabilityLogExplorer = (core, pluginsStart, ownPluginStart, appParams) => {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(ObservabilityLogExplorerApp, {
    appParams: appParams,
    core: core,
    plugins: pluginsStart,
    pluginStart: ownPluginStart
  }), appParams.element);
  return () => {
    // work around race condition between unmount effect and current app id
    // observable in the search session service
    pluginsStart.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(appParams.element);
  };
};
exports.renderObservabilityLogExplorer = renderObservabilityLogExplorer;
const ObservabilityLogExplorerApp = ({
  appParams,
  core,
  plugins,
  pluginStart
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins, pluginStart);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
    i18n: core.i18n,
    theme: core.theme
  }, /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: appParams.history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    exact: true,
    render: () => /*#__PURE__*/_react.default.createElement(_main.ObservablityLogExplorerMainRoute, {
      appParams: appParams,
      core: core
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/dataset-quality",
    exact: true,
    render: () => /*#__PURE__*/_react.default.createElement(_main.DatasetQualityRoute, {
      core: core
    })
  })))));
};
exports.ObservabilityLogExplorerApp = ObservabilityLogExplorerApp;