"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorRoutes = void 0;
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listConnectorsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/connectors',
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      request,
      plugins
    } = resources;
    const actionsClient = await (await plugins.actions.start()).getActionsClientWithRequest(request);
    const connectors = await actionsClient.getAll();
    return connectors.filter(connector => connector.actionTypeId === '.gen-ai');
  }
});
const connectorRoutes = {
  ...listConnectorsRoute
};
exports.connectorRoutes = connectorRoutes;