"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationView = ConversationView;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _uuid = require("uuid");
var _chat_body = require("../../components/chat/chat_body");
var _conversation_list = require("../../components/chat/conversation_list");
var _observability_ai_assistant_chat_service_provider = require("../../context/observability_ai_assistant_chat_service_provider");
var _use_abortable_async = require("../../hooks/use_abortable_async");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _use_current_user = require("../../hooks/use_current_user");
var _use_force_update = require("../../hooks/use_force_update");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _use_kibana = require("../../hooks/use_kibana");
var _use_knowledge_base = require("../../hooks/use_knowledge_base");
var _use_observability_ai_assistant = require("../../hooks/use_observability_ai_assistant");
var _use_observability_ai_assistant_params = require("../../hooks/use_observability_ai_assistant_params");
var _use_observability_ai_assistant_router = require("../../hooks/use_observability_ai_assistant_router");
var _i18n2 = require("../../i18n");
var _get_connectors_management_href = require("../../utils/get_connectors_management_href");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerClassName = (0, _css.css)`
  max-width: 100%;
`;
const conversationListContainerName = (0, _css.css)`
  min-width: 250px;
  width: 250px;
  border-right: solid 1px ${_uiTheme.euiThemeVars.euiColorLightShade};
`;
function ConversationView() {
  var _conversations$value2;
  const currentUser = (0, _use_current_user.useCurrentUser)();
  const service = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const knowledgeBase = (0, _use_knowledge_base.useKnowledgeBase)();
  const observabilityAIAssistantRouter = (0, _use_observability_ai_assistant_router.useObservabilityAIAssistantRouter)();
  const {
    path
  } = (0, _use_observability_ai_assistant_params.useObservabilityAIAssistantParams)('/conversations/*');
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const {
    element: confirmDeleteElement,
    confirm: confirmDeleteFunction
  } = (0, _use_confirm_modal.useConfirmModal)({
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.confirmDeleteConversationTitle', {
      defaultMessage: 'Delete this conversation?'
    }),
    children: _i18n.i18n.translate('xpack.observabilityAiAssistant.confirmDeleteConversationContent', {
      defaultMessage: 'This action cannot be undone.'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observabilityAiAssistant.confirmDeleteButtonText', {
      defaultMessage: 'Delete conversation'
    })
  });
  const [isUpdatingList, setIsUpdatingList] = (0, _react.useState)(false);
  const chatService = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    return service.start({
      signal
    });
  }, [service]);
  const conversationId = 'conversationId' in path ? path.conversationId : undefined;

  // Regenerate the key only when the id changes, except after
  // creating the conversation. Ideally this happens by adding
  // state to the current route, but I'm not keen on adding
  // the concept of state to the router, due to a mismatch
  // between router.link() and router.push(). So, this is a
  // pretty gross workaround for persisting a key under some
  // conditions.
  const chatBodyKeyRef = (0, _react.useRef)((0, _uuid.v4)());
  const keepPreviousKeyRef = (0, _react.useRef)(false);
  const prevConversationId = (0, _usePrevious.default)(conversationId);
  if (conversationId !== prevConversationId && keepPreviousKeyRef.current === false) {
    chatBodyKeyRef.current = (0, _uuid.v4)();
  }
  keepPreviousKeyRef.current = false;
  const forceUpdate = (0, _use_force_update.useForceUpdate)();
  const conversations = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    return service.callApi('POST /internal/observability_ai_assistant/conversations', {
      signal
    });
  }, [service]);
  const displayedConversations = (0, _react.useMemo)(() => {
    var _conversations$value$, _conversations$value;
    return [...(!conversationId ? [{
      id: '',
      label: _i18n2.EMPTY_CONVERSATION_TITLE
    }] : []), ...((_conversations$value$ = (_conversations$value = conversations.value) === null || _conversations$value === void 0 ? void 0 : _conversations$value.conversations) !== null && _conversations$value$ !== void 0 ? _conversations$value$ : []).map(conv => ({
      id: conv.conversation.id,
      label: conv.conversation.title,
      href: observabilityAIAssistantRouter.link('/conversations/{conversationId}', {
        path: {
          conversationId: conv.conversation.id
        }
      })
    }))];
  }, [(_conversations$value2 = conversations.value) === null || _conversations$value2 === void 0 ? void 0 : _conversations$value2.conversations, conversationId, observabilityAIAssistantRouter]);
  function navigateToConversation(nextConversationId, usePrevConversationKey) {
    if (nextConversationId) {
      observabilityAIAssistantRouter.push('/conversations/{conversationId}', {
        path: {
          conversationId: nextConversationId
        },
        query: {}
      });
    } else {
      observabilityAIAssistantRouter.push('/conversations/new', {
        path: {},
        query: {}
      });
    }
  }
  function handleRefreshConversations() {
    conversations.refresh();
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, confirmDeleteElement, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    className: containerClassName,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: conversationListContainerName
  }, /*#__PURE__*/_react.default.createElement(_conversation_list.ConversationList, {
    selected: conversationId !== null && conversationId !== void 0 ? conversationId : '',
    loading: conversations.loading || isUpdatingList,
    error: conversations.error,
    conversations: displayedConversations,
    onClickNewChat: () => {
      if (conversationId) {
        observabilityAIAssistantRouter.push('/conversations/new', {
          path: {},
          query: {}
        });
      } else {
        // clear the chat
        chatBodyKeyRef.current = (0, _uuid.v4)();
        forceUpdate();
      }
    },
    onClickDeleteConversation: id => {
      confirmDeleteFunction().then(async confirmed => {
        var _conversations$value3;
        if (!confirmed) {
          return;
        }
        setIsUpdatingList(true);
        await service.callApi('DELETE /internal/observability_ai_assistant/conversation/{conversationId}', {
          params: {
            path: {
              conversationId: id
            }
          },
          signal: null
        });
        const isCurrentConversation = id === conversationId;
        const hasOtherConversations = (_conversations$value3 = conversations.value) === null || _conversations$value3 === void 0 ? void 0 : _conversations$value3.conversations.find(conv => 'id' in conv.conversation && conv.conversation.id !== id);
        if (isCurrentConversation) {
          navigateToConversation(hasOtherConversations ? conversations.value.conversations[0].conversation.id : undefined);
        }
        conversations.refresh();
      }).catch(error => {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.observabilityAiAssistant.failedToDeleteConversation', {
            defaultMessage: 'Could not delete conversation'
          })
        });
      }).finally(() => {
        setIsUpdatingList(false);
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), !chatService.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }))) : null, chatService.value && /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_chat_service_provider.ObservabilityAIAssistantChatServiceProvider, {
    value: chatService.value
  }, /*#__PURE__*/_react.default.createElement(_chat_body.ChatBody, {
    key: chatBodyKeyRef.current,
    currentUser: currentUser,
    connectors: connectors,
    connectorsManagementHref: (0, _get_connectors_management_href.getConnectorsManagementHref)(http),
    initialConversationId: conversationId,
    knowledgeBase: knowledgeBase,
    startedFrom: "conversationView",
    onConversationUpdate: conversation => {
      if (!conversationId) {
        keepPreviousKeyRef.current = true;
        navigateToConversation(conversation.conversation.id);
      }
      handleRefreshConversations();
    }
  }))));
}