"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservabilityAIAssistantRouter = useObservabilityAIAssistantRouter;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _config = require("../routes/config");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useObservabilityAIAssistantRouter() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const link = (...args) => {
    // @ts-expect-error
    return _config.observabilityAIAssistantRouter.link(...args);
  };
  return (0, _react.useMemo)(() => ({
    ..._config.observabilityAIAssistantRouter,
    push: (...args) => {
      const next = link(...args);
      history.push(next);
    },
    replace: (path, ...args) => {
      const next = link(path, ...args);
      history.replace(next);
    },
    link: (path, ...args) => {
      return http.basePath.prepend('/app/observabilityAIAssistant' + link(path, ...args));
    }
  }), [http, history]);
}