"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeMessageKnowledgeBase = WelcomeMessageKnowledgeBase;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _useTimeoutFn = _interopRequireDefault(require("react-use/lib/useTimeoutFn"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _welcome_message_knowledge_base_setup_error_panel = require("./welcome_message_knowledge_base_setup_error_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WelcomeMessageKnowledgeBase({
  connectors,
  knowledgeBase
}) {
  var _knowledgeBase$status, _knowledgeBase$status3, _knowledgeBase$status5, _knowledgeBase$status6, _connectors$connector;
  const previouslyNotInstalled = (0, _usePrevious.default)(((_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.ready) === false);
  const [showHasBeenInstalled, setShowHasBeenInstalled] = (0, _react.useState)(false);
  const [timeoutTime, setTimeoutTime] = (0, _react.useState)(0);
  const [,, reset] = (0, _useTimeoutFn.default)(() => setShowHasBeenInstalled(false), timeoutTime);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const handleClosePopover = () => setIsPopoverOpen(false);
  const [checkForInstallStatus, setCheckForInstallStatus] = (0, _react.useState)(false);

  // When the knowledge base is installed, show a success message for 3 seconds
  (0, _react.useEffect)(() => {
    var _knowledgeBase$status2;
    if (previouslyNotInstalled && (_knowledgeBase$status2 = knowledgeBase.status.value) !== null && _knowledgeBase$status2 !== void 0 && _knowledgeBase$status2.ready) {
      setTimeoutTime(3000);
      reset();
      setShowHasBeenInstalled(true);
    }
  }, [(_knowledgeBase$status3 = knowledgeBase.status.value) === null || _knowledgeBase$status3 === void 0 ? void 0 : _knowledgeBase$status3.ready, previouslyNotInstalled, reset]);

  // When the knowledge base is installed, stop checking for install status
  (0, _react.useEffect)(() => {
    var _knowledgeBase$status4;
    if (!checkForInstallStatus && (_knowledgeBase$status4 = knowledgeBase.status.value) !== null && _knowledgeBase$status4 !== void 0 && _knowledgeBase$status4.ready) {
      setCheckForInstallStatus(false);
    }
  }, [checkForInstallStatus, (_knowledgeBase$status5 = knowledgeBase.status.value) === null || _knowledgeBase$status5 === void 0 ? void 0 : _knowledgeBase$status5.ready]);

  // Check for install status every 5 seconds
  (0, _useInterval.default)(() => {
    knowledgeBase.status.refresh();
  }, checkForInstallStatus ? 5000 : null);
  const handleRetryInstall = async () => {
    setCheckForInstallStatus(true);
    setIsPopoverOpen(false);
    await knowledgeBase.install().then(() => {
      setCheckForInstallStatus(false);
    });
  };
  return ((_knowledgeBase$status6 = knowledgeBase.status.value) === null || _knowledgeBase$status6 === void 0 ? void 0 : _knowledgeBase$status6.ready) !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, knowledgeBase.isInstalling ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.weAreSettingUpTextLabel', {
    defaultMessage: 'We are setting up your knowledge base. This may take a few minutes. You can continue to use the Assistant while this process is underway.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityAiAssistantWelcomeMessageSettingUpKnowledgeBaseButton",
    isLoading: true,
    onClick: _lodash.noop
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.div.settingUpKnowledgeBaseLabel', {
    defaultMessage: 'Setting up Knowledge base'
  }))) : null, (_connectors$connector = connectors.connectors) !== null && _connectors$connector !== void 0 && _connectors$connector.length ? !knowledgeBase.isInstalling && knowledgeBase.installError || !knowledgeBase.isInstalling && knowledgeBase.status.loading === false && knowledgeBase.status.value.ready === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessageKnowledgeBase.yourKnowledgeBaseIsNotSetUpCorrectlyLabel', {
    defaultMessage: `Your Knowledge base hasn't been set up.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "observabilityAiAssistantWelcomeMessageSetUpKnowledgeBaseButton",
    fill: true,
    isLoading: checkForInstallStatus,
    iconType: "importAction",
    onClick: handleRetryInstall
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.retryButtonLabel', {
    defaultMessage: 'Install Knowledge base'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilityAiAssistantWelcomeMessageInspectErrorsButton",
      iconType: "inspect",
      onClick: () => setIsPopoverOpen(!isPopoverOpen)
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.inspectErrorsButtonEmptyLabel', {
      defaultMessage: 'Inspect issues'
    })),
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    closePopover: handleClosePopover
  }, /*#__PURE__*/_react.default.createElement(_welcome_message_knowledge_base_setup_error_panel.WelcomeMessageKnowledgeBaseSetupErrorPanel, {
    knowledgeBase: knowledgeBase,
    onRetryInstall: handleRetryInstall
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null : null, showHasBeenInstalled ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessage.knowledgeBaseSuccessfullyInstalledLabel', {
    defaultMessage: 'Knowledge base successfully installed'
  }))))) : null) : null;
}