"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseCallout = KnowledgeBaseCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function KnowledgeBaseCallout({
  knowledgeBase
}) {
  var _knowledgeBase$status, _knowledgeBase$status2, _knowledgeBase$status3;
  let content;
  let color = 'primary';
  if (knowledgeBase.status.loading) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.checkingKbAvailability', {
      defaultMessage: 'Checking availability of knowledge base'
    }))));
  } else if (knowledgeBase.status.error) {
    color = 'danger';
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: color
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.failedToGetStatus', {
      defaultMessage: 'Failed to get model status.'
    }));
  } else if ((_knowledgeBase$status = knowledgeBase.status.value) !== null && _knowledgeBase$status !== void 0 && _knowledgeBase$status.ready) {
    color = 'plain';
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    }), ' ', _i18n.i18n.translate('xpack.observabilityAiAssistant.poweredByModel', {
      defaultMessage: 'Powered by {model}',
      values: {
        model: 'ELSER'
      }
    }));
  } else if (knowledgeBase.isInstalling) {
    color = 'primary';
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: color
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.installingKb', {
      defaultMessage: 'Setting up the knowledge base'
    }))));
  } else if (knowledgeBase.installError) {
    color = 'danger';
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: color
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.failedToSetupKnowledgeBase', {
      defaultMessage: 'Failed to set up knowledge base.'
    }));
  } else if (!((_knowledgeBase$status2 = knowledgeBase.status.value) !== null && _knowledgeBase$status2 !== void 0 && _knowledgeBase$status2.ready) && !knowledgeBase.status.error) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseCalloutLink",
      onClick: () => {
        knowledgeBase.install();
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    }), ' ', _i18n.i18n.translate('xpack.observabilityAiAssistant.setupKb', {
      defaultMessage: 'Improve your experience by setting up the knowledge base.'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_knowledgeBase$status3 = knowledgeBase.status.value) !== null && _knowledgeBase$status3 !== void 0 && _knowledgeBase$status3.ready ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    borderRadius: "none",
    color: color,
    paddingSize: "s",
    css: {
      width: 'max-content'
    }
  }, content));
}