"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationList = ConversationList;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _new_chat_button = require("../buttons/new_chat_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerClassName = (0, _css.css)`
  height: 100%;
`;
const titleClassName = (0, _css.css)`
  text-transform: uppercase;
`;
const panelClassName = (0, _css.css)`
  max-height: 100%;
`;
const overflowScrollClassName = (0, _css.css)`
  overflow-y: auto;
`;
const newChatButtonWrapperClassName = (0, _css.css)`
  padding-bottom: 5px;
`;
function ConversationList({
  selected,
  loading,
  error,
  conversations,
  onClickNewChat,
  onClickDeleteConversation
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    className: panelClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: overflowScrollClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: titleClassName,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.title', {
    defaultMessage: 'Previously'
  })))), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  })) : null))), error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "danger"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.errorMessage', {
    defaultMessage: 'Failed to load'
  })))))) : null, conversations !== null && conversations !== void 0 && conversations.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: false,
    gutterSize: "none"
  }, conversations === null || conversations === void 0 ? void 0 : conversations.map(conversation => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: conversation.id,
    label: conversation.label,
    size: "s",
    isActive: conversation.id === selected,
    isDisabled: loading,
    href: conversation.href,
    wrapText: true,
    extraAction: conversation.id ? {
      iconType: 'trash',
      'aria-label': _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.deleteConversationIconLabel', {
        defaultMessage: 'Delete'
      }),
      onClick: () => {
        onClickDeleteConversation(conversation.id);
      }
    } : undefined
  })))) : null, !loading && !error && !(conversations !== null && conversations !== void 0 && conversations.length) ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationList.noConversations', {
    defaultMessage: 'No conversations'
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: newChatButtonWrapperClassName
  }, /*#__PURE__*/_react.default.createElement(_new_chat_button.NewChatButton, {
    onClick: onClickNewChat
  })))))));
}