"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatTimeline = ChatTimeline;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _chat_item = require("./chat_item");
var _chat_consolidated_items = require("./chat_consolidated_items");
var _get_timeline_items_from_conversation = require("../../utils/get_timeline_items_from_conversation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatTimeline({
  messages,
  chatService,
  hasConnector,
  currentUser,
  startedFrom,
  onEdit,
  onFeedback,
  onRegenerate,
  onSendTelemetry,
  onStopGenerating,
  onActionClick,
  chatState
}) {
  const items = (0, _react.useMemo)(() => {
    const timelineItems = (0, _get_timeline_items_from_conversation.getTimelineItemsfromConversation)({
      chatService,
      hasConnector,
      messages,
      currentUser,
      startedFrom,
      chatState
    });
    const consolidatedChatItems = [];
    let currentGroup = null;
    for (const item of timelineItems) {
      if (item.display.hide || !item) continue;
      if (item.display.collapsed) {
        if (currentGroup) {
          currentGroup.push(item);
        } else {
          currentGroup = [item];
          consolidatedChatItems.push(currentGroup);
        }
      } else {
        consolidatedChatItems.push(item);
        currentGroup = null;
      }
    }
    return consolidatedChatItems;
  }, [chatService, hasConnector, messages, currentUser, startedFrom, chatState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    className: (0, _css.css)`
        padding-bottom: 32px;
      `
  }, items.map((item, index) => {
    return Array.isArray(item) ? /*#__PURE__*/_react.default.createElement(_chat_consolidated_items.ChatConsolidatedItems, {
      key: index,
      consolidatedItem: item,
      onActionClick: onActionClick,
      onEditSubmit: onEdit,
      onFeedback: onFeedback,
      onRegenerate: onRegenerate,
      onSendTelemetry: onSendTelemetry,
      onStopGenerating: onStopGenerating
    }) : /*#__PURE__*/_react.default.createElement(_chat_item.ChatItem
    // use index, not id to prevent unmounting of component when message is persisted
    , (0, _extends2.default)({
      key: index
    }, (0, _lodash.omit)(item, 'message'), {
      onActionClick: onActionClick,
      onFeedbackClick: feedback => {
        onFeedback(item.message, feedback);
      },
      onRegenerateClick: () => {
        onRegenerate(item.message);
      },
      onEditSubmit: message => {
        onEdit(item.message, message);
      },
      onSendTelemetry: onSendTelemetry,
      onStopGeneratingClick: onStopGenerating
    }));
  }));
}