"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItemAvatar = ChatItemAvatar;
var _react = _interopRequireDefault(require("react"));
var _userProfileComponents = require("@kbn/user-profile-components");
var _eui = require("@elastic/eui");
var _assistant_avatar = require("../assistant_avatar");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatItemAvatar({
  currentUser,
  role,
  loading
}) {
  const isLoading = loading || !currentUser;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  switch (role) {
    case _types.MessageRole.User:
      return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
        user: currentUser,
        size: "m",
        "data-test-subj": "userMenuAvatar"
      });
    case _types.MessageRole.Assistant:
    case _types.MessageRole.Elastic:
    case _types.MessageRole.Function:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "Elastic Assistant",
        iconType: _assistant_avatar.AssistantAvatar,
        color: "subdued"
      });
    case _types.MessageRole.System:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "system",
        iconType: "dot",
        color: "subdued"
      });
    default:
      return null;
  }
}