"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatConsolidatedItems = ChatConsolidatedItems;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _chat_item = require("./chat_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noPanelStyle = (0, _css.css)`
  .euiCommentEvent {
    border: none;
  }

  .euiCommentEvent__header {
    background: transparent;
    border-block-end: none;
  }

  .euiCommentEvent__body {
    display: none;
  }

  .euiLink {
    padding: 0;
  }

  .euiLink:focus {
    text-decoration: none;
  }

  .euiLink:hover {
    text-decoration: underline;
  }

  .euiAvatar {
    cursor: pointer;

    :hover {
      border: solid 2px #d3dae6;
    }
  }
`;
function ChatConsolidatedItems({
  consolidatedItem,
  onActionClick,
  onEditSubmit,
  onFeedback,
  onRegenerate,
  onSendTelemetry,
  onStopGenerating
}) {
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const handleToggleExpand = () => {
    setExpanded(!expanded);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    className: noPanelStyle,
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      color: "subdued",
      name: "inspect",
      iconType: "layers",
      onClick: handleToggleExpand
    }),
    event: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "subdued",
      "data-test-subj": "observabilityAiAssistantChatCollapsedItemsCollapsedItemsLink",
      onClick: handleToggleExpand
    }, /*#__PURE__*/_react.default.createElement("em", null, !expanded ? _i18n.i18n.translate('xpack.observabilityAiAssistant.chatCollapsedItems.showEvents', {
      defaultMessage: 'Show {count} events',
      values: {
        count: consolidatedItem.length
      }
    }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.chatCollapsedItems.hideEvents', {
      defaultMessage: 'Hide {count} events',
      values: {
        count: consolidatedItem.length
      }
    }))),
    username: "",
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatCollapsedItems.toggleButtonLabel', {
        defaultMessage: 'Show / hide items'
      }),
      color: "text",
      "data-test-subj": "observabilityAiAssistantChatCollapsedItemsButton",
      iconType: expanded ? 'arrowUp' : 'arrowDown',
      onClick: handleToggleExpand
    })
  }), expanded ? consolidatedItem.map((item, index) => /*#__PURE__*/_react.default.createElement(_chat_item.ChatItem
  // use index, not id to prevent unmounting of component when message is persisted
  , (0, _extends2.default)({
    key: index
  }, item, {
    onActionClick: onActionClick,
    onEditSubmit: message => onEditSubmit(item.message, message),
    onFeedbackClick: feedback => {
      onFeedback(item.message, feedback);
    },
    onRegenerateClick: () => {
      onRegenerate(item.message);
    },
    onSendTelemetry: onSendTelemetry,
    onStopGeneratingClick: onStopGenerating
  }))) : null);
}