"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatActionsMenu = ChatActionsMenu;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _get_settings_href = require("../../utils/get_settings_href");
var _get_settings_kb_href = require("../../utils/get_settings_kb_href");
var _connector_selector_base = require("../connector_selector/connector_selector_base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatActionsMenu({
  connectors,
  conversationId,
  disabled,
  onCopyConversationClick
}) {
  var _connectors$connector, _connectors$connector2;
  const {
    application: {
      navigateToUrl
    },
    http
  } = (0, _use_kibana.useKibana)().services;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const toggleActionsMenu = () => {
    setIsOpen(!isOpen);
  };
  const handleNavigateToSettings = () => {
    navigateToUrl((0, _get_settings_href.getSettingsHref)(http));
  };
  const handleNavigateToSettingsKnowledgeBase = () => {
    navigateToUrl((0, _get_settings_kb_href.getSettingsKnowledgeBaseHref)(http));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "observabilityAiAssistantChatActionsMenuButtonIcon",
      disabled: disabled,
      iconType: "boxesVertical",
      onClick: toggleActionsMenu,
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatActionsMenu.euiButtonIcon.menuLabel', {
        defaultMessage: 'Menu'
      })
    }),
    panelPaddingSize: "none",
    closePopover: toggleActionsMenu
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.actions.title', {
        defaultMessage: 'Actions'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.actions.settings', {
          defaultMessage: 'AI Assistant Settings'
        }),
        onClick: () => {
          toggleActionsMenu();
          handleNavigateToSettings();
        }
      }, {
        name: /*#__PURE__*/_react.default.createElement("div", {
          className: "eui-textTruncate"
        }, _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.actions.connector', {
          defaultMessage: 'Connector'
        }), ' ', /*#__PURE__*/_react.default.createElement("strong", null, (_connectors$connector = connectors.connectors) === null || _connectors$connector === void 0 ? void 0 : (_connectors$connector2 = _connectors$connector.find(({
          id
        }) => id === connectors.selectedConnector)) === null || _connectors$connector2 === void 0 ? void 0 : _connectors$connector2.name)),
        panel: 1
      }, {
        name: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.actions.knowledgeBase', {
          defaultMessage: 'Manage knowledge base'
        }),
        onClick: () => {
          toggleActionsMenu();
          handleNavigateToSettingsKnowledgeBase();
        }
      }, {
        name: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.actions.copyConversation', {
          defaultMessage: 'Copy conversation'
        }),
        disabled: !conversationId,
        onClick: () => {
          toggleActionsMenu();
          onCopyConversationClick();
        }
      }]
    }, {
      id: 1,
      width: 256,
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.actions.connector', {
        defaultMessage: 'Connector'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_connector_selector_base.ConnectorSelectorBase, connectors))
    }]
  }));
}