"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Application = Application;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _observability_ai_assistant_provider = require("./context/observability_ai_assistant_provider");
var _config = require("./routes/config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is the Conversation application.

function Application({
  coreStart,
  history,
  pluginsStart,
  service,
  theme$
}) {
  const theme = (0, _react.useMemo)(() => {
    return {
      theme$
    };
  }, [theme$]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: theme
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...pluginsStart,
      plugins: {
        start: pluginsStart
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart
  }, /*#__PURE__*/_react.default.createElement(coreStart.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_provider.ObservabilityAIAssistantProvider, {
    value: service
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.observabilityAIAssistantRouter
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, null))))))));
}