"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenu = TopNavMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _top_nav_menu_item = require("./top_nav_menu_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Top Nav Menu is a convenience wrapper component for:
 * - Top navigation menu - configured by an array of `TopNavMenuData` objects
 * - Search Bar - which includes Filter Bar \ Query Input \ Timepicker.
 *
 * See SearchBar documentation to learn more about its properties.
 *
 **/

function TopNavMenu(props) {
  const {
    config,
    badges,
    showSearchBar,
    ...searchBarProps
  } = props;
  if ((!config || config.length === 0) && (!showSearchBar || !props.unifiedSearch)) {
    return null;
  }
  function createBadge({
    badgeText,
    toolTipProps,
    renderCustomBadge,
    ...badgeProps
  }, i) {
    const key = `nav-menu-badge-${i}`;
    const Badge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      tabIndex: 0
    }, badgeProps), badgeText);
    if (renderCustomBadge) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: key
      }, renderCustomBadge({
        badgeText
      }));
    }
    return toolTipProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, (0, _extends2.default)({
      key: key
    }, toolTipProps), /*#__PURE__*/_react.default.createElement(Badge, null)) : /*#__PURE__*/_react.default.createElement(Badge, {
      key: key
    });
  }
  function renderBadges() {
    if (!badges || badges.length === 0) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      className: 'kbnTopNavMenu__badgeGroup'
    }, badges.map(createBadge));
  }
  function renderItems() {
    if (!config || config.length === 0) return null;
    return config.map((menuItem, i) => {
      return /*#__PURE__*/_react.default.createElement(_top_nav_menu_item.TopNavMenuItem, (0, _extends2.default)({
        key: `nav-menu-${i}`
      }, menuItem));
    });
  }
  function renderMenu(className) {
    if (!config || config.length === 0) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
      "data-test-subj": "top-nav",
      gutterSize: "xs",
      className: className
    }, renderItems());
  }
  function renderSearchBar() {
    // Validate presense of all required fields
    if (!showSearchBar || !props.unifiedSearch) return null;
    const {
      AggregateQuerySearchBar
    } = props.unifiedSearch.ui;
    return /*#__PURE__*/_react.default.createElement(AggregateQuerySearchBar, searchBarProps);
  }
  function renderLayout() {
    const {
      setMenuMountPoint,
      visible
    } = props;
    const menuClassName = (0, _classnames.default)('kbnTopNavMenu', props.className);
    const wrapperClassName = (0, _classnames.default)('kbnTopNavMenu__wrapper', {
      'kbnTopNavMenu__wrapper--hidden': visible === false
    });
    if (setMenuMountPoint) {
      const badgesEl = renderBadges();
      const menuEl = renderMenu(menuClassName);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (badgesEl || menuEl) && /*#__PURE__*/_react.default.createElement(_reactKibanaMount.MountPointPortal, {
        setMountPoint: setMenuMountPoint
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: `${wrapperClassName} kbnTopNavMenu__badgeWrapper`
      }, badgesEl, menuEl)), renderSearchBar());
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: wrapperClassName
      }, renderMenu(menuClassName)), renderSearchBar());
    }
  }
  return renderLayout();
}
TopNavMenu.defaultProps = {
  showSearchBar: false,
  showQueryInput: true,
  showDatePicker: true,
  showFilterBar: true,
  screenTitle: ''
};