"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricCell = MetricCell;
exports.OfflineCell = OfflineCell;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _format_number = require("../../../lib/format_number");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRENDING_DOWN = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.trendingDownText', {
  defaultMessage: 'down'
});
const TRENDING_UP = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.trendingUpText', {
  defaultMessage: 'up'
});
function OfflineCell() {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "monTableCell__offline"
  }, "N/A");
}
const getDirection = slope => {
  if (slope || slope === 0) {
    return slope > 0 ? TRENDING_UP : TRENDING_DOWN;
  }
  return null;
};
const getIcon = slope => {
  if (slope || slope === 0) {
    return slope > 0 ? 'sortUp' : 'sortDown';
  }
  return null;
};
const metricVal = (metric, format, isPercent, units) => {
  if (isPercent) {
    return (0, _format_number.formatMetric)(metric, format, '%', {
      prependSpace: false
    });
  }
  return (0, _format_number.formatMetric)(metric, format, units);
};
function MetricCell({
  isOnline,
  metric = {},
  isPercent,
  ...props
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isPopoverOpen => !isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  if (!isOnline) {
    return /*#__PURE__*/_react.default.createElement(OfflineCell, null);
  }
  const {
    lastVal,
    maxVal,
    minVal,
    slope
  } = (0, _lodash.get)(metric, 'summary', {});
  const format = (0, _lodash.get)(metric, 'metric.format');
  const units = (0, _lodash.get)(metric, 'metric.units');
  const tooltipItems = [{
    title: _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.trending', {
      defaultMessage: 'Trending'
    }),
    description: getDirection(slope)
  }, {
    title: _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.max', {
      defaultMessage: 'Max value'
    }),
    description: metricVal(maxVal, format, isPercent, units)
  }, {
    title: _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.min', {
      defaultMessage: 'Min value'
    }),
    description: metricVal(minVal, format, isPercent, units)
  }];
  const iconLabel = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.iconLabel', {
    defaultMessage: 'More information about this metric'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onButtonClick,
    iconType: getIcon(slope),
    "data-test-subj": `monitoringCellIcon-${props['data-test-subj']}`,
    title: iconLabel,
    "aria-label": iconLabel
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": props['data-test-subj'],
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `monitoringCellPopover-${props['data-test-subj']}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    listItems: tooltipItems,
    style: {
      maxWidth: '150px'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.preface', {
    defaultMessage: 'Applies to current time period'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, metricVal(lastVal, format, isPercent))))));
}